/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.logic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.verapdf.exceptions.validationlogic.MultiplyGlobalVariableNameException;
import org.verapdf.exceptions.validationlogic.NullLinkException;
import org.verapdf.exceptions.validationlogic.NullLinkNameException;
import org.verapdf.exceptions.validationlogic.NullLinkedObjectException;
import org.verapdf.exceptions.validationprofileparser.MissedHashTagException;
import org.verapdf.exceptions.validationprofileparser.WrongSignatureException;
import org.verapdf.validation.profile.model.Rule;
import org.verapdf.validation.profile.model.ValidationProfile;
import org.verapdf.validation.profile.model.Variable;
import org.verapdf.validation.profile.parser.ValidationProfileParser;
import org.verapdf.validation.report.model.Check;
import org.verapdf.validation.report.model.CheckError;
import org.verapdf.validation.report.model.CheckLocation;
import org.verapdf.validation.report.model.Details;
import org.verapdf.validation.report.model.Profile;
import org.verapdf.validation.report.model.Result;
import org.verapdf.validation.report.model.ValidationInfo;
import org.xml.sax.SAXException;

public class Validator {
    private static final int OPTIMIZATION_LEVEL = 9;
    private Context context;
    private ScriptableObject scope;
    private Deque<org.verapdf.model.baselayer.Object> objectsStack;
    private Deque<String> objectsContext;
    private Deque<Set<String>> contextSet;
    private Map<String, org.verapdf.validation.report.model.Rule> checkMap;
    private Map<String, Script> ruleScripts = new HashMap<String, Script>();
    private Map<String, List<Script>> ruleArgScripts = new HashMap<String, List<Script>>();
    private Map<String, Script> variableScripts = new HashMap<String, Script>();
    private Set<String> idSet;
    private String rootType;
    private ValidationProfile profile;
    private final boolean logPassedChecks;
    private final int maxFailedChecks;
    private final int maxDisplayedFailedChecks;
    private int rulesChecksCount = 0;

    private Validator(ValidationProfile profile, boolean logPassedChecks, int maxFailedChecks, int maxDisplayedFailedChecks) {
        this.profile = profile;
        this.logPassedChecks = logPassedChecks;
        this.maxFailedChecks = maxFailedChecks;
        this.maxDisplayedFailedChecks = maxDisplayedFailedChecks;
    }

    private ValidationInfo validate(org.verapdf.model.baselayer.Object root) throws NullLinkNameException, NullLinkException, NullLinkedObjectException {
        this.context = Context.enter();
        this.context.setOptimizationLevel(9);
        this.scope = this.context.initStandardObjects();
        this.objectsStack = new ArrayDeque<org.verapdf.model.baselayer.Object>();
        this.objectsContext = new ArrayDeque<String>();
        this.contextSet = new ArrayDeque<Set<String>>();
        ArrayList<String> warnings = new ArrayList<String>();
        this.idSet = new HashSet<String>();
        this.checkMap = new HashMap<String, org.verapdf.validation.report.model.Rule>();
        for (String id : this.profile.getAllRulesId()) {
            this.checkMap.put(id, new org.verapdf.validation.report.model.Rule(id, new ArrayList<Check>()));
        }
        this.initializeAllVariables();
        this.rootType = root.getObjectType();
        this.objectsStack.push(root);
        this.objectsContext.push("root");
        HashSet<String> rootIDContext = new HashSet<String>();
        if (root.getID() != null) {
            rootIDContext.add(root.getID());
            this.idSet.add(root.getID());
        }
        this.contextSet.push(rootIDContext);
        while (!this.objectsStack.isEmpty()) {
            this.checkNext();
        }
        Context.exit();
        ArrayList<org.verapdf.validation.report.model.Rule> rules = new ArrayList<org.verapdf.validation.report.model.Rule>(this.checkMap.values());
        int rulesCount = rules.size();
        for (int i = 0; i < rulesCount; ++i) {
            if (this.logPassedChecks || !((org.verapdf.validation.report.model.Rule)rules.get(i)).getChecks().isEmpty()) {
                ((org.verapdf.validation.report.model.Rule)rules.get(i)).setStatus();
                continue;
            }
            rules.set(i, null);
        }
        Profile profile = new Profile(this.profile.getName(), this.profile.getHash());
        Result result = new Result(new Details(rules, warnings, this.rulesChecksCount, rulesCount));
        return new ValidationInfo(profile, result);
    }

    private void initializeAllVariables() {
        for (Variable var : this.profile.getAllVariables()) {
            if (var == null) continue;
            Object res = this.context.evaluateString((Scriptable)this.scope, var.getDefaultValue(), null, 0, null);
            if (res instanceof NativeJavaObject) {
                res = ((NativeJavaObject)res).unwrap();
            }
            this.scope.put(var.getAttrName(), (Scriptable)this.scope, res);
        }
    }

    private boolean checkNext() throws NullLinkException, NullLinkedObjectException, NullLinkNameException {
        org.verapdf.model.baselayer.Object checkObject = this.objectsStack.pop();
        String checkContext = this.objectsContext.pop();
        Set<String> checkIDContext = this.contextSet.pop();
        boolean res = this.checkAllRules(checkObject, checkContext);
        this.updateVariables(checkObject);
        this.addAllLinkedObjects(checkObject, checkContext, checkIDContext);
        return res;
    }

    private void updateVariables(org.verapdf.model.baselayer.Object object) {
        if (object != null) {
            for (Variable var : this.profile.getVariablesForObject(object.getObjectType())) {
                if (var == null) continue;
                Object variable = this.evalVariableResult(var, object);
                this.scope.put(var.getAttrName(), (Scriptable)this.scope, variable);
            }
        }
    }

    private Object evalVariableResult(Variable variable, org.verapdf.model.baselayer.Object object) {
        Script script;
        if (!this.variableScripts.containsKey(variable.getAttrName())) {
            String source = Validator.getStringScript(object, variable.getValue());
            script = this.context.compileString(source, null, 0, null);
        } else {
            script = this.variableScripts.get(variable.getAttrName());
        }
        this.scope.put("obj", (Scriptable)this.scope, (Object)object);
        Object res = script.exec(this.context, (Scriptable)this.scope);
        if (res instanceof NativeJavaObject) {
            res = ((NativeJavaObject)res).unwrap();
        }
        return res;
    }

    private void addAllLinkedObjects(org.verapdf.model.baselayer.Object checkObject, String checkContext, Set<String> checkIDContext) throws NullLinkNameException, NullLinkException, NullLinkedObjectException {
        for (int j = checkObject.getLinks().size() - 1; j >= 0; --j) {
            String link = (String)checkObject.getLinks().get(j);
            if (link == null) {
                throw new NullLinkNameException("There is a null link name in an object. Context: " + checkContext);
            }
            List objects = checkObject.getLinkedObjects(link);
            if (objects == null) {
                throw new NullLinkException("There is a null link in an object. Context: " + checkContext);
            }
            for (int i = 0; i < objects.size(); ++i) {
                org.verapdf.model.baselayer.Object obj = (org.verapdf.model.baselayer.Object)objects.get(i);
                StringBuilder path = new StringBuilder(checkContext);
                path.append("/");
                path.append(link);
                path.append("[");
                path.append(i);
                path.append("]");
                if (obj == null) {
                    throw new NullLinkedObjectException("There is a null link in an object. Context of the link: " + path);
                }
                if (!this.checkRequired(obj, checkIDContext)) continue;
                this.objectsStack.push(obj);
                HashSet<String> newCheckIDContext = new HashSet<String>(checkIDContext);
                if (obj.getID() != null) {
                    path.append("(");
                    path.append(obj.getID());
                    path.append(")");
                    newCheckIDContext.add(obj.getID());
                    this.idSet.add(obj.getID());
                }
                this.objectsContext.push(path.toString());
                this.contextSet.push(newCheckIDContext);
            }
        }
    }

    private boolean checkRequired(org.verapdf.model.baselayer.Object obj, Set<String> checkIDContext) {
        if (obj.getID() == null) {
            return true;
        }
        if (obj.isContextDependent() == null || obj.isContextDependent().booleanValue()) {
            return !checkIDContext.contains(obj.getID());
        }
        return !this.idSet.contains(obj.getID());
    }

    private boolean checkAllRules(org.verapdf.model.baselayer.Object checkObject, String checkContext) {
        boolean res = true;
        List roolsForObject = this.profile.getRoolsForObject(checkObject.getObjectType());
        if (roolsForObject != null) {
            for (Rule rule : roolsForObject) {
                if (rule == null) continue;
                res &= this.checkObjWithRule(checkObject, checkContext, rule);
            }
        }
        for (String checkType : checkObject.getSuperTypes()) {
            roolsForObject = this.profile.getRoolsForObject(checkType);
            if (roolsForObject == null) continue;
            for (Rule rule : roolsForObject) {
                if (rule == null) continue;
                res &= this.checkObjWithRule(checkObject, checkContext, rule);
            }
        }
        return res;
    }

    private static String getScript(org.verapdf.model.baselayer.Object obj, Rule rule) {
        return Validator.getStringScript(obj, "(" + rule.getTest() + ")==true");
    }

    private static String getStringScript(org.verapdf.model.baselayer.Object obj, String arg) {
        return Validator.getScriptPrefix(obj, arg) + arg + Validator.getScriptSuffix();
    }

    private static String getScriptPrefix(org.verapdf.model.baselayer.Object obj, String test) {
        StringBuilder builder = new StringBuilder();
        String[] vars = test.split("\\W");
        for (String prop : obj.getProperties()) {
            if (!Validator.contains(vars, prop)) continue;
            builder.append("var ");
            builder.append(prop);
            builder.append(" = obj.get");
            builder.append(prop);
            builder.append("();\n");
        }
        for (String linkName : obj.getLinks()) {
            if (!Validator.contains(vars, linkName + "_size")) continue;
            builder.append("var ");
            builder.append(linkName);
            builder.append("_size = obj.getLinkedObjects(\"");
            builder.append(linkName);
            builder.append("\").size();\n");
        }
        builder.append("function test(){return ");
        return builder.toString();
    }

    private static boolean contains(String[] values, String prop) {
        for (String value : values) {
            if (!value.equals(prop)) continue;
            return true;
        }
        return false;
    }

    private static String getScriptSuffix() {
        return ";}\ntest();";
    }

    private boolean checkObjWithRule(org.verapdf.model.baselayer.Object obj, String context, Rule rule) {
        org.verapdf.validation.report.model.Rule currentRule = this.checkMap.get(rule.getAttrID());
        if (this.maxFailedChecks == -1 || currentRule.getFailedChecksCount() < this.maxFailedChecks) {
            Script scr;
            this.scope.put("obj", (Scriptable)this.scope, (Object)obj);
            if (!this.ruleScripts.containsKey(rule.getAttrID())) {
                scr = this.context.compileString(Validator.getScript(obj, rule), null, 0, null);
                this.ruleScripts.put(rule.getAttrID(), scr);
            } else {
                scr = this.ruleScripts.get(rule.getAttrID());
            }
            Boolean res = (Boolean)scr.exec(this.context, (Scriptable)this.scope);
            CheckLocation loc = new CheckLocation(this.rootType, context);
            Check check = null;
            if (!res.booleanValue()) {
                check = this.createFailCheck(obj, loc, rule);
            } else if (this.logPassedChecks) {
                check = new Check(Check.Status.PASSED, loc, null);
            }
            if (check != null) {
                if (currentRule.getFailedChecksCount() < this.maxDisplayedFailedChecks) {
                    currentRule.add(check);
                } else {
                    currentRule.incChecksCount(check);
                }
            } else {
                currentRule.incChecksCount();
            }
            ++this.rulesChecksCount;
            return res;
        }
        return true;
    }

    private Check createFailCheck(org.verapdf.model.baselayer.Object obj, CheckLocation loc, Rule rule) {
        ArrayList<String> argsRes = new ArrayList<String>();
        if (rule.getRuleError() == null) {
            return new Check(Check.Status.FAILED, loc, new CheckError(null, argsRes));
        }
        String errorMessage = rule.getRuleError().getMessage();
        List arguments = rule.getRuleError().getArgument();
        if (!arguments.isEmpty()) {
            List<Object> argsList;
            if (!this.ruleArgScripts.containsKey(rule.getAttrID())) {
                argsList = new ArrayList(arguments.size());
                for (String string : arguments) {
                    String argScript = Validator.getStringScript(obj, string);
                    Script script = this.context.compileString(argScript, null, 0, null);
                    argsList.add(script);
                }
                this.ruleArgScripts.put(rule.getAttrID(), argsList);
            } else {
                argsList = this.ruleArgScripts.get(rule.getAttrID());
            }
            for (Script script : argsList) {
                Object resArg = script.exec(this.context, (Scriptable)this.scope);
                String resStringArg = resArg instanceof NativeJavaObject ? ((NativeJavaObject)resArg).unwrap().toString() : resArg.toString();
                argsRes.add(resStringArg);
            }
        }
        CheckError error = new CheckError(errorMessage, argsRes);
        return new Check(Check.Status.FAILED, loc, error);
    }

    public static ValidationInfo validate(org.verapdf.model.baselayer.Object root, String validationProfilePath, boolean isSignCheckOn, boolean isLogPassedChecks, int maxFailedChecks, int maxDisplayedFailedChecks) throws IOException, SAXException, ParserConfigurationException, NullLinkNameException, NullLinkException, NullLinkedObjectException, MissedHashTagException, XMLStreamException, WrongSignatureException, MultiplyGlobalVariableNameException {
        if (root == null) {
            throw new IllegalArgumentException("Parameter (Object root) cannot be null.");
        }
        if (validationProfilePath == null) {
            throw new IllegalArgumentException("Parameter (String validationProfilePath) cannot be null.");
        }
        return Validator.validate(root, ValidationProfileParser.parseFromFilePath((String)validationProfilePath, (boolean)isSignCheckOn), isLogPassedChecks, maxFailedChecks, maxDisplayedFailedChecks);
    }

    public static ValidationInfo validate(org.verapdf.model.baselayer.Object root, File validationProfile, boolean isSignCheckOn, boolean isLogPassedChecks, int maxFailedChecks, int maxDisplayedFailedChecks) throws ParserConfigurationException, SAXException, IOException, NullLinkNameException, NullLinkException, NullLinkedObjectException, MissedHashTagException, XMLStreamException, WrongSignatureException, MultiplyGlobalVariableNameException {
        if (root == null) {
            throw new IllegalArgumentException("Parameter (Object root) cannot be null.");
        }
        if (validationProfile == null) {
            throw new IllegalArgumentException("Parameter (ValidationProfile validationProfile) cannot be null.");
        }
        return Validator.validate(root, ValidationProfileParser.parseFromFile((File)validationProfile, (boolean)isSignCheckOn), isLogPassedChecks, maxFailedChecks, maxDisplayedFailedChecks);
    }

    public static ValidationInfo validate(org.verapdf.model.baselayer.Object root, ValidationProfile validationProfile, boolean isLogPassedChecks, int maxFailedChecks, int maxDisplayedFailedChecks) throws NullLinkNameException, NullLinkException, NullLinkedObjectException {
        if (root == null) {
            throw new IllegalArgumentException("Parameter (Object root) cannot be null.");
        }
        if (validationProfile == null) {
            throw new IllegalArgumentException("Parameter (ValidationProfile validationProfile) cannot be null.");
        }
        Validator validator = new Validator(validationProfile, isLogPassedChecks, maxFailedChecks, maxDisplayedFailedChecks);
        return validator.validate(root);
    }
}

