/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.visitor.cos.pb;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.verapdf.model.impl.pb.cos.PBCosArray;
import org.verapdf.model.impl.pb.cos.PBCosBool;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.impl.pb.cos.PBCosDocument;
import org.verapdf.model.impl.pb.cos.PBCosIndirect;
import org.verapdf.model.impl.pb.cos.PBCosInteger;
import org.verapdf.model.impl.pb.cos.PBCosName;
import org.verapdf.model.impl.pb.cos.PBCosNull;
import org.verapdf.model.impl.pb.cos.PBCosReal;
import org.verapdf.model.impl.pb.cos.PBCosStream;
import org.verapdf.model.impl.pb.cos.PBCosString;

public final class PBCosVisitor
implements ICOSVisitor {
    private static final PBCosVisitor visitor = new PBCosVisitor();

    private PBCosVisitor() {
    }

    public static PBCosVisitor getInstance() {
        return visitor;
    }

    public Object visitFromArray(COSArray obj) throws IOException {
        return new PBCosArray(obj);
    }

    public Object visitFromBoolean(COSBoolean obj) throws IOException {
        return PBCosBool.valueOf(obj);
    }

    public Object visitFromDictionary(COSDictionary obj) throws IOException {
        return new PBCosDict(obj);
    }

    public Object visitFromDocument(COSDocument obj) throws IOException {
        return new PBCosDocument(obj);
    }

    public Object visitFromFloat(COSFloat obj) throws IOException {
        return new PBCosReal((COSNumber)obj);
    }

    public Object visitFromInt(COSInteger obj) throws IOException {
        return new PBCosInteger(obj);
    }

    public Object visitFromName(COSName obj) throws IOException {
        return new PBCosName(obj);
    }

    public Object visitFromNull(COSNull obj) throws IOException {
        return PBCosNull.getInstance();
    }

    public Object visitFromStream(COSStream obj) throws IOException {
        return new PBCosStream(obj);
    }

    public Object visitFromString(COSString obj) throws IOException {
        return new PBCosString(obj);
    }

    public static Object visitFromObject(COSObject obj) {
        return new PBCosIndirect(obj);
    }
}

