/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.operator.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.impl.pb.cos.PBCosReal;
import org.verapdf.model.operator.Operator;

public abstract class PBOperator
extends GenericModelObject
implements Operator {
    public static final int MAX_NUMBER_OF_ELEMENTS = 1;
    protected final List<COSBase> arguments;

    protected PBOperator(List<COSBase> arguments, String opType) {
        super(opType);
        this.arguments = arguments;
    }

    protected List<CosReal> getLastReal() {
        if (!this.arguments.isEmpty()) {
            ArrayList<PBCosReal> cosReals = new ArrayList<PBCosReal>(1);
            COSBase base = this.arguments.get(this.arguments.size() - 1);
            if (base instanceof COSNumber) {
                cosReals.add(new PBCosReal((COSNumber)base));
                return Collections.unmodifiableList(cosReals);
            }
        }
        return Collections.emptyList();
    }

    protected List<CosReal> getListOfReals() {
        ArrayList<CosReal> list = new ArrayList<CosReal>();
        for (COSBase base : this.arguments) {
            if (base instanceof COSArray) {
                PBOperator.addArrayElements(list, (COSArray)base);
                continue;
            }
            if (!(base instanceof COSNumber)) continue;
            list.add(new PBCosReal((COSNumber)base));
        }
        return Collections.unmodifiableList(list);
    }

    private static void addArrayElements(List<CosReal> list, COSArray base) {
        for (COSBase arg : base) {
            if (!(arg instanceof COSNumber)) continue;
            list.add(new PBCosReal((COSNumber)arg));
        }
    }
}

