/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.tools;

import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public final class PBCreateNodeHelper {
    private static final Logger LOGGER = Logger.getLogger(PBCreateNodeHelper.class);
    private static final String LLX = "llx";
    private static final String LLY = "lly";
    private static final String URX = "urx";
    private static final String URY = "ury";
    private static final int GRAY_COLOR_COMPONENTS_NUMBER = 1;
    private static final int RGB_COLOR_COMPONENTS_NUMBER = 3;
    private static final int CMYK_COLOR_COMPONENTS_NUMBER = 4;
    private static final int GRAY_COMPONENT_NUMBER = 0;
    private static final int RED_COMPONENT_NUMBER = 0;
    private static final int GREEN_COMPONENT_NUMBER = 1;
    private static final int BLUE_COMPONENT_NUMBER = 2;
    private static final int CYAN_COMPONENT_NUMBER = 0;
    private static final int MAGENTA_COMPONENT_NUMBER = 1;
    private static final int YELLOW_COMPONENT_NUMBER = 2;
    private static final int BLACK_COMPONENT_NUMBER = 3;

    private PBCreateNodeHelper() {
    }

    private static String getXMLFormat(Calendar calendar) throws DatatypeConfigurationException {
        GregorianCalendar greg = new GregorianCalendar(Locale.US);
        greg.setTime(calendar.getTime());
        greg.setTimeZone(calendar.getTimeZone());
        XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(greg);
        return xmlCalendar.toXMLFormat();
    }

    public static FeatureTreeNode createDateNode(String nodeName, FeatureTreeNode parent, Calendar date, FeaturesCollection collection) throws FeaturesTreeNodeException {
        FeatureTreeNode modificationDate = null;
        if (date != null) {
            modificationDate = FeatureTreeNode.newChildInstance(nodeName, parent);
            try {
                modificationDate.setValue(PBCreateNodeHelper.getXMLFormat(date));
            }
            catch (DatatypeConfigurationException e) {
                LOGGER.debug((Object)"DatatypeFactory implementation not available or can't be instantiated", (Throwable)e);
                modificationDate.addAttribute("errorID", "dateerr1");
                ErrorsHelper.addErrorIntoCollection(collection, "dateerr1", "A serious configuration error while creating xml formatted date field.");
            }
        }
        return modificationDate;
    }

    public static String getStringFromBase(COSBase baseParam) {
        COSBase base = baseParam;
        while (base instanceof COSObject) {
            base = ((COSObject)base).getObject();
        }
        if (base instanceof COSString) {
            COSString str = (COSString)base;
            return str.isHex() != false ? str.toHexString() : str.getString();
        }
        return null;
    }

    public static FeatureTreeNode addBoxFeature(String name, PDRectangle box, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        FeatureTreeNode boxNode = null;
        if (box != null) {
            boxNode = FeatureTreeNode.newChildInstance(name, parent);
            boxNode.addAttribute(LLX, String.valueOf(box.getLowerLeftX()));
            boxNode.addAttribute(LLY, String.valueOf(box.getLowerLeftY()));
            boxNode.addAttribute(URX, String.valueOf(box.getUpperRightX()));
            boxNode.addAttribute(URY, String.valueOf(box.getUpperRightY()));
        }
        return boxNode;
    }

    public static FeatureTreeNode addNotEmptyNode(String name, String value, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        if (name != null && value != null) {
            return FeatureTreeNode.newChildInstanceWithValue(name, value, parent);
        }
        return null;
    }

    public static FeatureTreeNode addDeviceColorSpaceNode(String name, PDColor color, FeatureTreeNode parent, FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (name != null && color != null) {
            FeatureTreeNode colorNode = FeatureTreeNode.newChildInstance(name, parent);
            float[] numbers = color.getComponents();
            switch (numbers.length) {
                case 1: {
                    PBCreateNodeHelper.createGray(color.getComponents(), colorNode);
                    break;
                }
                case 3: {
                    PBCreateNodeHelper.createRGB(color.getComponents(), colorNode);
                    break;
                }
                case 4: {
                    PBCreateNodeHelper.createCMYK(color.getComponents(), colorNode);
                    break;
                }
                default: {
                    colorNode.addAttribute("errorID", "colorerr1");
                    ErrorsHelper.addErrorIntoCollection(collection, "colorerr1", "Devise color space contains wrong number of components.");
                }
            }
            return colorNode;
        }
        return null;
    }

    public static void parseIDSet(Set<String> set, String elementName, String setName, FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (set != null && !set.isEmpty()) {
            FeatureTreeNode setNode = setName == null ? root : FeatureTreeNode.newChildInstance(setName, root);
            for (String entry : set) {
                if (entry == null) continue;
                FeatureTreeNode entryNode = FeatureTreeNode.newChildInstance(elementName, setNode);
                entryNode.addAttribute("id", entry);
            }
        }
    }

    public static FeatureTreeNode parseMetadata(PDMetadata metadata, String nodeName, FeatureTreeNode parent, FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (metadata == null) {
            return null;
        }
        FeatureTreeNode node = parent == null ? FeatureTreeNode.newRootInstance(nodeName) : FeatureTreeNode.newChildInstance(nodeName, parent);
        try {
            byte[] bStream = metadata.getByteArray();
            node.setValue(bStream);
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Error while converting stream to string", (Throwable)e);
            node.addAttribute("errorID", "metaerr1");
            ErrorsHelper.addErrorIntoCollection(collection, "metaerr1", "Error while converting metadata stream with use of ISO-8859-1 encoding.");
        }
        return node;
    }

    private static void createGray(float[] components, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        FeatureTreeNode.newChildInstanceWithValue("gray", String.valueOf(components[0]), parent);
    }

    private static void createRGB(float[] components, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        FeatureTreeNode.newChildInstanceWithValue("red", String.valueOf(components[0]), parent);
        FeatureTreeNode.newChildInstanceWithValue("green", String.valueOf(components[1]), parent);
        FeatureTreeNode.newChildInstanceWithValue("blue", String.valueOf(components[2]), parent);
    }

    private static void createCMYK(float[] components, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        FeatureTreeNode.newChildInstanceWithValue("cyan", String.valueOf(components[0]), parent);
        FeatureTreeNode.newChildInstanceWithValue("magenta", String.valueOf(components[1]), parent);
        FeatureTreeNode.newChildInstanceWithValue("yellow", String.valueOf(components[2]), parent);
        FeatureTreeNode.newChildInstanceWithValue("black", String.valueOf(components[3]), parent);
    }
}

