/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBTilingPatternFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDTilingPattern tilingPattern;
    private String id;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> procSetChild;
    private Set<String> propertiesChild;
    private Set<String> pageParent;
    private Set<String> patternParent;
    private Set<String> xobjectParent;
    private Set<String> fontParent;

    public PBTilingPatternFeaturesObject(PDTilingPattern tilingPattern, String id, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> procSetChild, Set<String> propertiesChild, Set<String> pageParent, Set<String> patternParent, Set<String> xobjectParent, Set<String> fontParent) {
        this.tilingPattern = tilingPattern;
        this.id = id;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.procSetChild = procSetChild;
        this.propertiesChild = propertiesChild;
        this.pageParent = pageParent;
        this.patternParent = patternParent;
        this.xobjectParent = xobjectParent;
        this.fontParent = fontParent;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.PATTERN;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.tilingPattern != null) {
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("pattern");
            root.addAttribute(ID, this.id);
            root.addAttribute("type", "tiling");
            this.parseParents(root);
            FeatureTreeNode.newChildInstanceWithValue("paintType", String.valueOf(this.tilingPattern.getPaintType()), root);
            FeatureTreeNode.newChildInstanceWithValue("tilingType", String.valueOf(this.tilingPattern.getTilingType()), root);
            PBCreateNodeHelper.addBoxFeature("bbox", this.tilingPattern.getBBox(), root);
            FeatureTreeNode.newChildInstanceWithValue("xStep", String.valueOf(this.tilingPattern.getXStep()), root);
            FeatureTreeNode.newChildInstanceWithValue("yStep", String.valueOf(this.tilingPattern.getYStep()), root);
            this.parseFloatMatrix(this.tilingPattern.getMatrix().getValues(), FeatureTreeNode.newChildInstance("matrix", root));
            this.parseResources(root);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.PATTERN, root);
            return root;
        }
        return null;
    }

    private void parseFloatMatrix(float[][] array, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array.length - 1; ++j) {
                FeatureTreeNode element = FeatureTreeNode.newChildInstance("element", parent);
                element.addAttribute("row", String.valueOf(i + 1));
                element.addAttribute("column", String.valueOf(j + 1));
                element.addAttribute("value", String.valueOf(array[i][j]));
            }
        }
    }

    private void parseParents(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.pageParent != null && !this.pageParent.isEmpty() || this.patternParent != null && !this.patternParent.isEmpty() || this.xobjectParent != null && !this.xobjectParent.isEmpty() || this.fontParent != null && !this.fontParent.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.newChildInstance("parents", root);
            PBCreateNodeHelper.parseIDSet(this.pageParent, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParent, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParent, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParent, "font", null, parents);
        }
    }

    private void parseResources(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.procSetChild != null && !this.procSetChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = FeatureTreeNode.newChildInstance("resources", root);
            PBCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            PBCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            PBCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            PBCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            PBCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            PBCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            PBCreateNodeHelper.parseIDSet(this.procSetChild, "procSet", "procSets", resources);
            PBCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

