/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.List;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBFontFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDFontLike fontLike;
    private String id;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> procSetChild;
    private Set<String> propertiesChild;
    private Set<String> extGStateParent;
    private Set<String> pageParent;
    private Set<String> patternParent;
    private Set<String> xobjectParent;
    private Set<String> fontParent;

    public PBFontFeaturesObject(PDFontLike fontLike, String id, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> procSetChild, Set<String> propertiesChild, Set<String> extGStateParent, Set<String> pageParent, Set<String> patternParent, Set<String> xobjectParent, Set<String> fontParent) {
        this.fontLike = fontLike;
        this.id = id;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.procSetChild = procSetChild;
        this.propertiesChild = propertiesChild;
        this.extGStateParent = extGStateParent;
        this.pageParent = pageParent;
        this.patternParent = patternParent;
        this.xobjectParent = xobjectParent;
        this.fontParent = fontParent;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.FONT;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.fontLike != null) {
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("font");
            root.addAttribute(ID, this.id);
            this.parseParents(root);
            if (this.fontLike instanceof PDFont) {
                PDFont font = (PDFont)this.fontLike;
                PBCreateNodeHelper.addNotEmptyNode("type", font.getSubType(), root);
                PBCreateNodeHelper.addNotEmptyNode("baseFont", font.getName(), root);
                if (font instanceof PDType0Font) {
                    PBCreateNodeHelper.parseIDSet(this.fontChild, "descendedFont", null, FeatureTreeNode.newChildInstance("descendedFonts", root));
                    PBFontFeaturesObject.parseFontDescriptior(this.fontLike.getFontDescriptor(), root);
                } else if (font instanceof PDSimpleFont) {
                    COSBase name;
                    int lc;
                    PDSimpleFont sFont = (PDSimpleFont)font;
                    int fc = sFont.getCOSObject().getInt(COSName.FIRST_CHAR);
                    if (fc != -1) {
                        FeatureTreeNode.newChildInstanceWithValue("firstChar", String.valueOf(fc), root);
                    }
                    if ((lc = sFont.getCOSObject().getInt(COSName.LAST_CHAR)) != -1) {
                        FeatureTreeNode.newChildInstanceWithValue("lastChar", String.valueOf(lc), root);
                    }
                    PBFontFeaturesObject.parseIntList(sFont.getWidths(), FeatureTreeNode.newChildInstance("widths", root));
                    COSBase enc = sFont.getCOSObject().getDictionaryObject(COSName.ENCODING);
                    if (enc instanceof COSName) {
                        PBCreateNodeHelper.addNotEmptyNode("encoding", ((COSName)enc).getName(), root);
                    } else if (enc instanceof COSDictionary && (name = ((COSDictionary)enc).getDictionaryObject(COSName.BASE_ENCODING)) instanceof COSName) {
                        PBCreateNodeHelper.addNotEmptyNode("encoding", ((COSName)name).getName(), root);
                    }
                    PBFontFeaturesObject.parseFontDescriptior(this.fontLike.getFontDescriptor(), root);
                    if (sFont instanceof PDType3Font) {
                        PDType3Font type3 = (PDType3Font)sFont;
                        PBCreateNodeHelper.addBoxFeature("fontBBox", type3.getFontBBox(), root);
                        PBFontFeaturesObject.parseFloatMatrix(type3.getFontMatrix().getValues(), FeatureTreeNode.newChildInstance("fontMatrix", root));
                        this.parseResources(root);
                    }
                }
            } else if (this.fontLike instanceof PDCIDFont) {
                PDCIDFont cid = (PDCIDFont)this.fontLike;
                PBCreateNodeHelper.addNotEmptyNode("type", cid.getCOSObject().getNameAsString(COSName.SUBTYPE), root);
                PBCreateNodeHelper.addNotEmptyNode("baseFont", cid.getBaseFont(), root);
                COSBase dw = cid.getCOSObject().getDictionaryObject(COSName.DW);
                if (dw instanceof COSNumber) {
                    FeatureTreeNode.newChildInstanceWithValue("defaultWidth", String.valueOf(((COSNumber)dw).floatValue()), root);
                }
                if (cid.getCIDSystemInfo() != null) {
                    FeatureTreeNode cidS = FeatureTreeNode.newChildInstance("cidSystemInfo", root);
                    PBCreateNodeHelper.addNotEmptyNode("registry", cid.getCIDSystemInfo().getRegistry(), cidS);
                    PBCreateNodeHelper.addNotEmptyNode("ordering", cid.getCIDSystemInfo().getOrdering(), cidS);
                    FeatureTreeNode.newChildInstanceWithValue("supplement", String.valueOf(cid.getCIDSystemInfo().getSupplement()), cidS);
                }
                PBFontFeaturesObject.parseFontDescriptior(this.fontLike.getFontDescriptor(), root);
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.FONT, root);
            return root;
        }
        return null;
    }

    private static void parseFontDescriptior(PDFontDescriptor descriptor, FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (descriptor != null) {
            FeatureTreeNode descriptorNode = FeatureTreeNode.newChildInstance("fontDescriptor", root);
            PBCreateNodeHelper.addNotEmptyNode("fontName", descriptor.getFontName(), descriptorNode);
            PBCreateNodeHelper.addNotEmptyNode("fontFamily", descriptor.getFontFamily(), descriptorNode);
            PBCreateNodeHelper.addNotEmptyNode("fontStretch", descriptor.getFontStretch(), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("fontWeight", String.valueOf(descriptor.getFontWeight()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("fixedPitch", String.valueOf(descriptor.isFixedPitch()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("serif", String.valueOf(descriptor.isSerif()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("symbolic", String.valueOf(descriptor.isSymbolic()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("script", String.valueOf(descriptor.isScript()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("nonsymbolic", String.valueOf(descriptor.isNonSymbolic()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("italic", String.valueOf(descriptor.isItalic()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("allCap", String.valueOf(descriptor.isAllCap()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("smallCap", String.valueOf(descriptor.isScript()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("forceBold", String.valueOf(descriptor.isForceBold()), descriptorNode);
            PBCreateNodeHelper.addBoxFeature("fontBBox", descriptor.getFontBoundingBox(), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("italicAngle", String.valueOf(descriptor.getItalicAngle()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("ascent", String.valueOf(descriptor.getAscent()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("descent", String.valueOf(descriptor.getDescent()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("leading", String.valueOf(descriptor.getLeading()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("capHeight", String.valueOf(descriptor.getCapHeight()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("xHeight", String.valueOf(descriptor.getXHeight()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("stemV", String.valueOf(descriptor.getStemV()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("stemH", String.valueOf(descriptor.getStemH()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("averageWidth", String.valueOf(descriptor.getAverageWidth()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("maxWidth", String.valueOf(descriptor.getMaxWidth()), descriptorNode);
            FeatureTreeNode.newChildInstanceWithValue("missingWidth", String.valueOf(descriptor.getMissingWidth()), descriptorNode);
            PBCreateNodeHelper.addNotEmptyNode("charSet", descriptor.getCharSet(), descriptorNode);
        }
    }

    private static void parseFloatMatrix(float[][] array, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array.length - 1; ++j) {
                FeatureTreeNode element = FeatureTreeNode.newChildInstance("element", parent);
                element.addAttribute("row", String.valueOf(i));
                element.addAttribute("column", String.valueOf(j));
                element.addAttribute("value", String.valueOf(array[i][j]));
            }
        }
    }

    private static void parseIntList(List<Integer> array, FeatureTreeNode parent) throws FeaturesTreeNodeException {
        for (int i = 0; i < array.size(); ++i) {
            FeatureTreeNode element = FeatureTreeNode.newChildInstance("element", parent);
            element.addAttribute("number", String.valueOf(i));
            element.addAttribute("value", String.valueOf(array.get(i)));
        }
    }

    private void parseParents(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.pageParent != null && !this.pageParent.isEmpty() || this.extGStateParent != null && !this.extGStateParent.isEmpty() || this.patternParent != null && !this.patternParent.isEmpty() || this.xobjectParent != null && !this.xobjectParent.isEmpty() || this.fontParent != null && !this.fontParent.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.newChildInstance("parents", root);
            PBCreateNodeHelper.parseIDSet(this.pageParent, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.extGStateParent, "graphicsState", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParent, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParent, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParent, "font", null, parents);
        }
    }

    private void parseResources(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.procSetChild != null && !this.procSetChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = FeatureTreeNode.newChildInstance("resources", root);
            PBCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            PBCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            PBCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            PBCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            PBCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            PBCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            PBCreateNodeHelper.parseIDSet(this.procSetChild, "procSet", "procSets", resources);
            PBCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

