/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBExtGStateFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDExtendedGraphicsState exGState;
    private String id;
    private String fontChildID;
    private Set<String> pageParentsID;
    private Set<String> patternParentsID;
    private Set<String> xobjectParentsID;
    private Set<String> fontParentsID;

    public PBExtGStateFeaturesObject(PDExtendedGraphicsState exGState, String id, String fontChildID, Set<String> pageParentsID, Set<String> patternParentsID, Set<String> xobjectParentsID, Set<String> fontParentsID) {
        this.exGState = exGState;
        this.id = id;
        this.fontChildID = fontChildID;
        this.pageParentsID = pageParentsID;
        this.patternParentsID = patternParentsID;
        this.xobjectParentsID = xobjectParentsID;
        this.fontParentsID = fontParentsID;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.EXT_G_STATE;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.exGState != null) {
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("graphicsState");
            root.addAttribute(ID, this.id);
            this.parseParents(root);
            FeatureTreeNode.newChildInstanceWithValue("transparency", String.valueOf(!this.exGState.getAlphaSourceFlag()), root);
            FeatureTreeNode.newChildInstanceWithValue("strokeAdjustment", String.valueOf(this.exGState.getAutomaticStrokeAdjustment()), root);
            FeatureTreeNode.newChildInstanceWithValue("overprintForStroke", String.valueOf(this.exGState.getStrokingOverprintControl()), root);
            FeatureTreeNode.newChildInstanceWithValue("overprintForFill", String.valueOf(this.exGState.getNonStrokingOverprintControl()), root);
            if (this.fontChildID != null) {
                FeatureTreeNode resources = FeatureTreeNode.newChildInstance("resources", root);
                FeatureTreeNode fonts = FeatureTreeNode.newChildInstance("fonts", resources);
                FeatureTreeNode font = FeatureTreeNode.newChildInstance("font", fonts);
                font.addAttribute(ID, this.fontChildID);
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.EXT_G_STATE, root);
            return root;
        }
        return null;
    }

    private void parseParents(FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (this.pageParentsID != null && !this.pageParentsID.isEmpty() || this.patternParentsID != null && !this.patternParentsID.isEmpty() || this.xobjectParentsID != null && !this.xobjectParentsID.isEmpty() || this.fontParentsID != null && !this.fontParentsID.isEmpty()) {
            FeatureTreeNode parents = FeatureTreeNode.newChildInstance("parents", root);
            PBCreateNodeHelper.parseIDSet(this.pageParentsID, "page", null, parents);
            PBCreateNodeHelper.parseIDSet(this.patternParentsID, "pattern", null, parents);
            PBCreateNodeHelper.parseIDSet(this.xobjectParentsID, "xobject", null, parents);
            PBCreateNodeHelper.parseIDSet(this.fontParentsID, "font", null, parents);
        }
    }
}

