/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBEmbeddedFileFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(PBEmbeddedFileFeaturesObject.class);
    private static final String CREATION_DATE = "creationDate";
    private static final String MOD_DATE = "modDate";
    private PDComplexFileSpecification embFile;
    private int index;

    public PBEmbeddedFileFeaturesObject(PDComplexFileSpecification embFile, int index) {
        this.embFile = embFile;
        this.index = index;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.EMBEDDED_FILE;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.embFile != null) {
            FeatureTreeNode root = FeatureTreeNode.newRootInstance("embeddedFile");
            root.addAttribute("id", "file" + this.index);
            PBCreateNodeHelper.addNotEmptyNode("fileName", this.embFile.getFilename(), root);
            PBCreateNodeHelper.addNotEmptyNode("description", this.embFile.getFileDescription(), root);
            PDEmbeddedFile ef = this.embFile.getEmbeddedFile();
            if (ef != null) {
                PBCreateNodeHelper.addNotEmptyNode("subtype", ef.getSubtype(), root);
                PBCreateNodeHelper.addNotEmptyNode("filter", PBEmbeddedFileFeaturesObject.getFilters(ef.getFilters()), root);
                try {
                    PBCreateNodeHelper.createDateNode(CREATION_DATE, root, ef.getCreationDate(), collection);
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"PDFBox error obtaining creation date", (Throwable)e);
                    FeatureTreeNode creationDate = FeatureTreeNode.newChildInstance(CREATION_DATE, root);
                    creationDate.addAttribute("errorID", "dateerr1");
                    ErrorsHelper.addErrorIntoCollection(collection, "dateerr1", "A serious configuration error while creating xml formatted date field.");
                }
                try {
                    PBCreateNodeHelper.createDateNode(MOD_DATE, root, ef.getModDate(), collection);
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"PDFBox error obtaining modification date", (Throwable)e);
                    FeatureTreeNode modDate = FeatureTreeNode.newChildInstance(MOD_DATE, root);
                    modDate.addAttribute("errorID", "dateerr1");
                    ErrorsHelper.addErrorIntoCollection(collection, "dateerr1", "A serious configuration error while creating xml formatted date field.");
                }
                PBCreateNodeHelper.addNotEmptyNode("checkSum", ef.getCheckSum(), root);
                PBCreateNodeHelper.addNotEmptyNode("size", String.valueOf(ef.getSize()), root);
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.EMBEDDED_FILE, root);
            return root;
        }
        return null;
    }

    private static String getFilters(List<COSName> list) {
        if (list != null) {
            StringBuilder builder = new StringBuilder();
            for (COSName filter : list) {
                if (filter == null || filter.getName() == null) continue;
                builder.append(filter.getName());
                builder.append(" ");
            }
            return builder.toString().trim();
        }
        return null;
    }
}

