/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.report.model;

import java.util.Collections;
import java.util.List;
import org.verapdf.validation.report.model.Check;

public class Rule {
    private final String ID;
    private Check.Status status;
    private List<Check> checks;
    private int checksCount;
    private int failedChecksCount;

    public Rule(String attrID, List<Check> checks) {
        this.ID = attrID;
        this.checks = checks;
        this.checksCount = checks.size();
    }

    public String getID() {
        return this.ID;
    }

    public Check.Status getStatus() {
        return this.status;
    }

    public void setStatus() {
        Check.Status ruleStatus = Check.Status.PASSED;
        for (Check check : this.checks) {
            if (Check.Status.FAILED != check.getStatus()) continue;
            ruleStatus = Check.Status.FAILED;
            break;
        }
        this.checks = Collections.unmodifiableList(this.checks);
        this.status = ruleStatus;
    }

    public List<Check> getChecks() {
        return this.checks;
    }

    public void incChecksCount() {
        ++this.checksCount;
    }

    public int getFailedChecksCount() {
        return this.failedChecksCount;
    }

    public void incFailedChecksCount() {
        ++this.failedChecksCount;
    }

    public int getPassedChecksCount() {
        return this.checksCount - this.failedChecksCount;
    }

    public void add(Check check) {
        this.checks.add(check);
        this.incChecksCount(check);
    }

    public void incChecksCount(Check check) {
        this.incChecksCount();
        if (check.getStatus() == Check.Status.FAILED) {
            this.incFailedChecksCount();
        }
    }
}

