/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.exceptions.validationlogic.MultiplyGlobalVariableNameException;
import org.verapdf.exceptions.validationlogic.NullLinkException;
import org.verapdf.exceptions.validationlogic.NullLinkNameException;
import org.verapdf.exceptions.validationlogic.NullLinkedObjectException;
import org.verapdf.exceptions.validationprofileparser.MissedHashTagException;
import org.verapdf.exceptions.validationprofileparser.WrongSignatureException;
import org.verapdf.features.pb.PBFeatureParser;
import org.verapdf.features.tools.FeaturesCollection;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.gui.tools.SettingsHelper;
import org.verapdf.model.ModelLoader;
import org.verapdf.model.coslayer.CosDocument;
import org.verapdf.report.HTMLReport;
import org.verapdf.report.XMLReport;
import org.verapdf.validation.logic.Validator;
import org.verapdf.validation.report.model.ValidationInfo;
import org.xml.sax.SAXException;

public class ValidateWorker
extends SwingWorker<ValidationInfo, Integer> {
    private static final Logger LOGGER = Logger.getLogger(ValidateWorker.class);
    private File pdf;
    private File profile;
    private CheckerPanel parent;
    private Properties settings;
    private File xmlReport = null;
    private File htmlReport = null;
    private long startTimeOfValidation;
    private long endTimeOfValidation;

    public ValidateWorker(CheckerPanel parent, File pdf, File profile, Properties settings) {
        this.parent = parent;
        this.pdf = pdf;
        this.profile = profile;
        this.settings = settings;
    }

    @Override
    protected ValidationInfo doInBackground() {
        ValidationInfo info = null;
        FeaturesCollection collection = null;
        this.startTimeOfValidation = System.currentTimeMillis();
        try (ModelLoader loader = new ModelLoader(this.pdf.getPath());){
            int flag = SettingsHelper.getProcessingType(this.settings);
            if ((flag & 1) == 1) {
                CosDocument root = loader.getRoot();
                info = this.runValidator((org.verapdf.model.baselayer.Object)root);
            }
            if ((flag & 2) == 2) {
                try {
                    collection = PBFeatureParser.getFeaturesCollection((PDDocument)loader.getPDDocument());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.parent, "Some error in creating features collection.", "Error", 0);
                    LOGGER.error((Object)"Exception in creating features collection: ", (Throwable)e);
                }
            }
            try {
                loader.getPDDocument().close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.parent, "Some error in closing document.", "Error", 0);
                LOGGER.error((Object)"Exception in closing document: ", (Throwable)e);
            }
            this.endTimeOfValidation = System.currentTimeMillis();
            this.writeReports(info, collection);
        }
        catch (IOException e) {
            this.parent.errorInValidatingOccur("Some error in parsing pdf.", e);
        }
        return info;
    }

    private ValidationInfo runValidator(org.verapdf.model.baselayer.Object root) {
        try {
            return Validator.validate((org.verapdf.model.baselayer.Object)root, (File)this.profile, (boolean)false, (boolean)SettingsHelper.isDispPassedRules(this.settings), (int)SettingsHelper.getNumbOfFail(this.settings), (int)SettingsHelper.getNumbOfFailDisp(this.settings));
        }
        catch (IOException | ParserConfigurationException | XMLStreamException | MultiplyGlobalVariableNameException | NullLinkException | NullLinkNameException | NullLinkedObjectException | MissedHashTagException | WrongSignatureException | SAXException e) {
            this.parent.errorInValidatingOccur("Some error in validating.", e);
            return null;
        }
    }

    @Override
    protected void done() {
        this.parent.validationEnded(this.xmlReport, this.htmlReport);
    }

    private void writeReports(ValidationInfo info, FeaturesCollection collection) {
        if (info != null || collection != null) {
            try {
                File dir = new File("./temp/");
                if (!dir.exists() && !dir.mkdir()) {
                    throw new IOException("Can not create temporary directory.");
                }
                this.xmlReport = new File("./temp/tempXMLReport.xml");
                XMLReport.writeXMLReport((ValidationInfo)info, (FeaturesCollection)collection, (String)this.xmlReport.getPath(), (long)(this.endTimeOfValidation - this.startTimeOfValidation), (boolean)SettingsHelper.isDispPassedRules(this.settings));
                if (info != null) {
                    try {
                        this.htmlReport = new File("./temp/tempHTMLReport.html");
                        HTMLReport.writeHTMLReport((String)this.htmlReport.getPath(), (File)this.xmlReport, (File)this.profile);
                    }
                    catch (IOException | TransformerException e) {
                        JOptionPane.showMessageDialog(this.parent, "Some error in saving the HTML report.", "Error", 0);
                        LOGGER.error((Object)"Exception saving the HTML report", (Throwable)e);
                        this.htmlReport = null;
                    }
                }
            }
            catch (IOException | DatatypeConfigurationException | ParserConfigurationException | TransformerException e) {
                JOptionPane.showMessageDialog(this.parent, "Some error in saving the XML report.", "Error", 0);
                LOGGER.error((Object)"Exception saving the XML report", (Throwable)e);
                this.xmlReport = null;
            }
        }
    }
}

