/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLFeaturesReport {
    private static final Logger LOGGER = Logger.getLogger(XMLFeaturesReport.class);
    private static final int XD7FF = 55295;
    private static final int XE000 = 57344;
    private static final int XFFFD = 65533;
    private static final int X10000 = 65536;
    private static final int X10FFFF = 0x10FFFF;
    private static final int SP = 32;
    private static final int HT = 9;
    private static final int LF = 10;
    private static final int CR = 13;
    private static final byte[] UTF8_METADATA_PREFIX_SQ = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 98, 101, 103, 105, 110, 61, 39, -17, -69, -65, 39};
    private static final byte[] UTF8_METADATA_PREFIX_DQ = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 98, 101, 103, 105, 110, 61, 34, -17, -69, -65, 34};
    private static final byte[] UTF8_METADATA_PREFIX_SQ_EMPTY = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 98, 101, 103, 105, 110, 61, 39, 39};
    private static final byte[] UTF8_METADATA_PREFIX_DQ_EMPTY = new byte[]{60, 63, 120, 112, 97, 99, 107, 101, 116, 32, 98, 101, 103, 105, 110, 61, 34, 34};
    private static final byte[] UTF16BE_METADATA_PREFIX_SQ = new byte[]{0, 60, 0, 63, 0, 120, 0, 112, 0, 97, 0, 99, 0, 107, 0, 101, 0, 116, 0, 32, 0, 98, 0, 101, 0, 103, 0, 105, 0, 110, 0, 61, 0, 39, -2, -1, 0, 39};
    private static final byte[] UTF16BE_METADATA_PREFIX_DQ = new byte[]{0, 60, 0, 63, 0, 120, 0, 112, 0, 97, 0, 99, 0, 107, 0, 101, 0, 116, 0, 32, 0, 98, 0, 101, 0, 103, 0, 105, 0, 110, 0, 61, 0, 34, -2, -1, 0, 34};
    private static final byte[] UTF16LE_METADATA_PREFIX_SQ = new byte[]{60, 0, 63, 0, 120, 0, 112, 0, 97, 0, 99, 0, 107, 0, 101, 0, 116, 0, 32, 0, 98, 0, 101, 0, 103, 0, 105, 0, 110, 0, 61, 0, 39, 0, -1, -2, 39, 0};
    private static final byte[] UTF16LE_METADATA_PREFIX_DQ = new byte[]{60, 0, 63, 0, 120, 0, 112, 0, 97, 0, 99, 0, 107, 0, 101, 0, 116, 0, 32, 0, 98, 0, 101, 0, 103, 0, 105, 0, 110, 0, 61, 0, 34, 0, -1, -2, 34, 0};
    private static final byte[] UTF32BE_METADATA_PREFIX_SQ = new byte[]{0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 112, 0, 0, 0, 97, 0, 0, 0, 99, 0, 0, 0, 107, 0, 0, 0, 101, 0, 0, 0, 116, 0, 0, 0, 32, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 103, 0, 0, 0, 105, 0, 0, 0, 110, 0, 0, 0, 61, 0, 0, 0, 39, 0, 0, -2, -1, 0, 0, 0, 39};
    private static final byte[] UTF32BE_METADATA_PREFIX_DQ = new byte[]{0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 112, 0, 0, 0, 97, 0, 0, 0, 99, 0, 0, 0, 107, 0, 0, 0, 101, 0, 0, 0, 116, 0, 0, 0, 32, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 103, 0, 0, 0, 105, 0, 0, 0, 110, 0, 0, 0, 61, 0, 0, 0, 34, 0, 0, -2, -1, 0, 0, 0, 34};
    private static final byte[] UTF32LE_METADATA_PREFIX_SQ = new byte[]{60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 112, 0, 0, 0, 97, 0, 0, 0, 99, 0, 0, 0, 107, 0, 0, 0, 101, 0, 0, 0, 116, 0, 0, 0, 32, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 103, 0, 0, 0, 105, 0, 0, 0, 110, 0, 0, 0, 61, 0, 0, 0, 39, 0, 0, 0, -1, -2, 0, 0, 39, 0, 0, 0};
    private static final byte[] UTF32LE_METADATA_PREFIX_DQ = new byte[]{60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 112, 0, 0, 0, 97, 0, 0, 0, 99, 0, 0, 0, 107, 0, 0, 0, 101, 0, 0, 0, 116, 0, 0, 0, 32, 0, 0, 0, 98, 0, 0, 0, 101, 0, 0, 0, 103, 0, 0, 0, 105, 0, 0, 0, 110, 0, 0, 0, 61, 0, 0, 0, 34, 0, 0, 0, -1, -2, 0, 0, 34, 0, 0, 0};

    private XMLFeaturesReport() {
    }

    public static Element makeXMLTree(FeaturesCollection collection, Document doc) {
        Element pdfFeatures = doc.createElement("pdfFeatures");
        if (collection != null) {
            XMLFeaturesReport.parseElements(FeaturesObjectTypesEnum.INFORMATION_DICTIONARY, collection, pdfFeatures, doc);
            if (collection.getFeatureTreesForType(FeaturesObjectTypesEnum.METADATA) != null) {
                for (FeatureTreeNode metadataNode : collection.getFeatureTreesForType(FeaturesObjectTypesEnum.METADATA)) {
                    if (metadataNode == null) continue;
                    pdfFeatures.appendChild(XMLFeaturesReport.parseMetadata(metadataNode, collection, doc));
                }
            }
            XMLFeaturesReport.parseElements(FeaturesObjectTypesEnum.DOCUMENT_SECURITY, collection, pdfFeatures, doc);
            XMLFeaturesReport.parseElements(FeaturesObjectTypesEnum.LOW_LEVEL_INFO, collection, pdfFeatures, doc);
            XMLFeaturesReport.makeList("embeddedFiles", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.EMBEDDED_FILE), pdfFeatures, collection, doc);
            XMLFeaturesReport.makeList("iccProfiles", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.ICCPROFILE), pdfFeatures, collection, doc);
            XMLFeaturesReport.makeList("outputIntents", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.OUTPUTINTENT), pdfFeatures, collection, doc);
            XMLFeaturesReport.parseElements(FeaturesObjectTypesEnum.OUTLINES, collection, pdfFeatures, doc);
            XMLFeaturesReport.makeList("annotations", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.ANNOTATION), pdfFeatures, collection, doc);
            XMLFeaturesReport.makeList("pages", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.PAGE), pdfFeatures, collection, doc);
            Element resources = doc.createElement("resources");
            XMLFeaturesReport.makeList("graphicsStates", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.EXT_G_STATE), resources, collection, doc);
            XMLFeaturesReport.makeList("colorSpaces", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.COLORSPACE), resources, collection, doc);
            XMLFeaturesReport.makeList("patterns", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.PATTERN), resources, collection, doc);
            XMLFeaturesReport.makeList("shadings", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.SHADING), resources, collection, doc);
            Element xobjects = doc.createElement("xobjects");
            XMLFeaturesReport.makeList("images", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.IMAGE_XOBJECT), xobjects, collection, doc);
            XMLFeaturesReport.makeList("forms", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.FORM_XOBJECT), xobjects, collection, doc);
            XMLFeaturesReport.makeList("failed", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.FAILED_XOBJECT), xobjects, collection, doc);
            if (xobjects.getChildNodes().getLength() > 0) {
                resources.appendChild(xobjects);
            }
            XMLFeaturesReport.makeList("fonts", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.FONT), resources, collection, doc);
            XMLFeaturesReport.makeList("procSets", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.PROCSET), resources, collection, doc);
            XMLFeaturesReport.makeList("propertiesDicts", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.PROPERTIES), resources, collection, doc);
            if (resources.getChildNodes().getLength() > 0) {
                pdfFeatures.appendChild(resources);
            }
            XMLFeaturesReport.makeList("errors", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.ERROR), pdfFeatures, collection, doc);
        }
        return pdfFeatures;
    }

    private static void parseElements(FeaturesObjectTypesEnum type, FeaturesCollection collection, Element root, Document doc) {
        for (FeatureTreeNode rootNode : collection.getFeatureTreesForType(type)) {
            if (rootNode == null) continue;
            root.appendChild(XMLFeaturesReport.makeNode(rootNode, collection, doc));
        }
    }

    private static void makeList(String listName, List<FeatureTreeNode> list, Element parent, FeaturesCollection collection, Document doc) {
        if (!list.isEmpty()) {
            Element listElement = doc.createElement(listName);
            for (FeatureTreeNode node : list) {
                if (node == null) continue;
                listElement.appendChild(XMLFeaturesReport.makeNode(node, collection, doc));
            }
            parent.appendChild(listElement);
        }
    }

    private static Element makeNode(FeatureTreeNode node, FeaturesCollection collection, Document doc) {
        if ("metadata".equalsIgnoreCase(node.getName())) {
            return XMLFeaturesReport.parseMetadata(node, collection, doc);
        }
        Element root = doc.createElement(node.getName());
        for (Map.Entry attr : node.getAttributes().entrySet()) {
            root.setAttribute((String)attr.getKey(), XMLFeaturesReport.replaceInvalidCharacters((String)attr.getValue()));
        }
        if (node.getValue() != null) {
            root.appendChild(doc.createTextNode(XMLFeaturesReport.replaceInvalidCharacters(node.getValue().toString())));
        } else if (node.getChildren() != null) {
            for (FeatureTreeNode child : node.getChildren()) {
                root.appendChild(XMLFeaturesReport.makeNode(child, collection, doc));
            }
        }
        return root;
    }

    private static Element parseMetadata(FeatureTreeNode metadataNode, FeaturesCollection collection, Document doc) {
        if (metadataNode.getAttributes().get("errorID") == null) {
            Element metadata = doc.createElement(metadataNode.getName());
            for (Map.Entry attr : metadataNode.getAttributes().entrySet()) {
                metadata.setAttribute((String)attr.getKey(), XMLFeaturesReport.replaceInvalidCharacters((String)attr.getValue()));
            }
            try {
                InputSource is = XMLFeaturesReport.getInputSourceWithEncoding((byte[])metadataNode.getValue());
                if (is != null) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document metadataDocument = builder.parse(is);
                    Node pack = doc.importNode(metadataDocument.getDocumentElement(), true);
                    pack.normalize();
                    metadata.appendChild(pack);
                } else {
                    LOGGER.debug((Object)"Metadata stream does not contains valid prefix.");
                    XMLFeaturesReport.parseMetadataError(collection, metadata);
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOGGER.debug((Object)"Caught exception and checking XML String.", (Throwable)e);
                XMLFeaturesReport.parseMetadataError(collection, metadata);
            }
            return metadata;
        }
        return XMLFeaturesReport.makeNode(metadataNode, collection, doc);
    }

    private static String replaceInvalidCharacters(String source) {
        try (Formatter formatter = new Formatter();){
            for (int i = 0; i < source.length(); ++i) {
                char curChar = source.charAt(i);
                if ('#' == curChar) {
                    formatter.format("#x%06X", "#".codePointAt(0));
                    continue;
                }
                int codePoint = source.codePointAt(i);
                if (Character.isHighSurrogate(curChar)) {
                    ++i;
                }
                if (codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF) {
                    formatter.format("%c", Character.valueOf(curChar));
                    if (!Character.isHighSurrogate(curChar) || i >= source.length()) continue;
                    formatter.format("%c", Character.valueOf(source.charAt(i)));
                    continue;
                }
                formatter.format("#x%06X", codePoint);
            }
            String string = formatter.toString();
            return string;
        }
    }

    private static void parseMetadataError(FeaturesCollection collection, Element metadata) {
        metadata.setAttribute("errorID", "metaerr2");
        ErrorsHelper.addErrorIntoCollection((FeaturesCollection)collection, (String)"metaerr2", (String)"Error while parsing metadata into DOM.");
    }

    private static InputSource getInputSourceWithEncoding(byte[] array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                String encoding = XMLFeaturesReport.getEncodingWithBegin(array, i);
                if (encoding == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(Arrays.copyOfRange(array, i, array.length));
                InputSource source = new InputSource(is);
                source.setEncoding(encoding);
                return source;
            }
        }
        return null;
    }

    private static String getEncodingWithBegin(byte[] bStream, int beginOffset) {
        if (beginOffset >= 0) {
            if (XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF32BE_METADATA_PREFIX_DQ) || XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF32BE_METADATA_PREFIX_SQ)) {
                return "UTF-32BE";
            }
            if (XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF32LE_METADATA_PREFIX_DQ) || XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF32LE_METADATA_PREFIX_SQ)) {
                return "UTF-32LE";
            }
            if (XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF16BE_METADATA_PREFIX_DQ) || XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF16BE_METADATA_PREFIX_SQ)) {
                return "UTF-16BE";
            }
            if (XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF16LE_METADATA_PREFIX_DQ) || XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF16LE_METADATA_PREFIX_SQ)) {
                return "UTF-16LE";
            }
            if (XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF8_METADATA_PREFIX_DQ) || XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF8_METADATA_PREFIX_DQ_EMPTY) || XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF8_METADATA_PREFIX_SQ) || XMLFeaturesReport.matchesFrom(bStream, beginOffset, UTF8_METADATA_PREFIX_SQ_EMPTY)) {
                return "UTF-8";
            }
        }
        return null;
    }

    private static boolean matchesFrom(byte[] source, int from, byte[] match) {
        if (match.length > source.length - from) {
            return false;
        }
        for (int i = 0; i < match.length; ++i) {
            if (source[i + from] == match[i]) continue;
            return false;
        }
        return true;
    }
}

