/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.impl.pb.cos.PBCosDict;

public class PBCosStream
extends PBCosDict
implements CosStream {
    private static final Logger logger = Logger.getLogger(PBCosStream.class);
    public static final String COS_STREAM_TYPE = "CosStream";
    public static final String F_DECODE_PARMS = "FDecodeParms";
    private final Long length;
    private final Long originalLength;
    private final String filters;
    private final String fileSpec;
    private final String fFilter;
    private final String fDecodeParams;
    private final boolean isSpacingPDFACompliant;

    public PBCosStream(COSStream stream) {
        super((COSDictionary)stream, COS_STREAM_TYPE);
        this.length = PBCosStream.parseLength(stream);
        this.originalLength = stream.getOriginLength();
        this.filters = PBCosStream.parseFilters(stream.getFilters());
        this.fileSpec = stream.getItem("F") != null ? stream.getItem("F").toString() : null;
        this.fFilter = PBCosStream.parseFilters(stream.getDictionaryObject(COSName.F_FILTER));
        this.fDecodeParams = stream.getItem(F_DECODE_PARMS) != null ? stream.getItem(F_DECODE_PARMS).toString() : null;
        this.isSpacingPDFACompliant = stream.getStreamSpacingsComplyPDFA() != false && stream.getEndStreamSpacingsComplyPDFA() != false;
    }

    public Long getLength() {
        return this.length;
    }

    public String getfilters() {
        return this.filters;
    }

    public String getF() {
        return this.fileSpec;
    }

    public String getFFilter() {
        return this.fFilter;
    }

    public String getFDecodeParms() {
        return this.fDecodeParams;
    }

    public Boolean getspacingCompliesPDFA() {
        return this.isSpacingPDFACompliant;
    }

    public Boolean getisLengthCorrect() {
        return this.length != null && this.length.equals(this.originalLength);
    }

    private static Long parseLength(COSStream stream) {
        COSBase number = stream.getDictionaryObject(COSName.LENGTH);
        return number instanceof COSNumber ? Long.valueOf(((COSNumber)number).longValue()) : null;
    }

    private static String parseFilters(COSBase base) {
        StringBuilder filters = new StringBuilder();
        if (base == null) {
            return null;
        }
        if (base instanceof COSName) {
            return ((COSName)base).getName();
        }
        if (base instanceof COSArray) {
            for (COSBase filter : (COSArray)base) {
                if (filter instanceof COSName) {
                    filters.append(((COSName)filter).getName()).append(" ");
                    continue;
                }
                logger.error((Object)("Incorrect type for stream filter " + filter.getClass().getName()));
            }
        } else {
            logger.error((Object)("Incorrect type for stream filter " + base.getClass().getName()));
            return null;
        }
        return filters.substring(0, filters.length() - 1);
    }
}

