/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.operator;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.verapdf.model.factory.operator.GraphicState;
import org.verapdf.model.impl.pb.operator.color.PBOpColor;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_J_line_cap;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_M_miter_limit;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_d;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_gs;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_i;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_j_line_join;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_ri;
import org.verapdf.model.impl.pb.operator.generalgs.PBOp_w_line_width;
import org.verapdf.model.impl.pb.operator.inlineimage.PBOp_BI;
import org.verapdf.model.impl.pb.operator.inlineimage.PBOp_EI;
import org.verapdf.model.impl.pb.operator.inlineimage.PBOp_ID;
import org.verapdf.model.impl.pb.operator.markedcontent.PBOp_BDC;
import org.verapdf.model.impl.pb.operator.markedcontent.PBOp_BMC;
import org.verapdf.model.impl.pb.operator.markedcontent.PBOp_DP;
import org.verapdf.model.impl.pb.operator.markedcontent.PBOp_EMC;
import org.verapdf.model.impl.pb.operator.markedcontent.PBOp_MP;
import org.verapdf.model.impl.pb.operator.opclip.PBOp_WStar;
import org.verapdf.model.impl.pb.operator.opclip.PBOp_W_clip;
import org.verapdf.model.impl.pb.operator.opcompability.PBOp_BX;
import org.verapdf.model.impl.pb.operator.opcompability.PBOp_EX;
import org.verapdf.model.impl.pb.operator.opcompability.PBOp_Undefined;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_c;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_h;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_l;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_m_moveto;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_re;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_v;
import org.verapdf.model.impl.pb.operator.pathconstruction.PBOp_y;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_BStar_eofill_stroke;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_B_fill_stroke;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_FStar;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_F_fill_obsolete;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_S_stroke;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_b_closepath_fill_stroke;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_bstar_closepath_eofill_stroke;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_f_fill;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_n;
import org.verapdf.model.impl.pb.operator.pathpaint.PBOp_s_close_stroke;
import org.verapdf.model.impl.pb.operator.shading.PBOp_sh;
import org.verapdf.model.impl.pb.operator.specialgs.PBOp_Q_grestore;
import org.verapdf.model.impl.pb.operator.specialgs.PBOp_cm;
import org.verapdf.model.impl.pb.operator.specialgs.PBOp_q_gsave;
import org.verapdf.model.impl.pb.operator.textobject.PBOpTextObject;
import org.verapdf.model.impl.pb.operator.textposition.PBOpTextPosition;
import org.verapdf.model.impl.pb.operator.textposition.PBOp_TD_Big;
import org.verapdf.model.impl.pb.operator.textposition.PBOp_Td;
import org.verapdf.model.impl.pb.operator.textposition.PBOp_Tm;
import org.verapdf.model.impl.pb.operator.textshow.PBOp_DoubleQuote;
import org.verapdf.model.impl.pb.operator.textshow.PBOp_Quote;
import org.verapdf.model.impl.pb.operator.textshow.PBOp_TJ_Big;
import org.verapdf.model.impl.pb.operator.textshow.PBOp_Tj;
import org.verapdf.model.impl.pb.operator.textstate.PBOp_Tc;
import org.verapdf.model.impl.pb.operator.textstate.PBOp_Tf;
import org.verapdf.model.impl.pb.operator.textstate.PBOp_Tl;
import org.verapdf.model.impl.pb.operator.textstate.PBOp_Tr;
import org.verapdf.model.impl.pb.operator.textstate.PBOp_Ts;
import org.verapdf.model.impl.pb.operator.textstate.PBOp_Tw;
import org.verapdf.model.impl.pb.operator.textstate.PBOp_Tz;
import org.verapdf.model.impl.pb.operator.type3font.PBOp_d0;
import org.verapdf.model.impl.pb.operator.type3font.PBOp_d1;
import org.verapdf.model.impl.pb.operator.xobject.PBOp_Do;
import org.verapdf.model.operator.Operator;

class OperatorParser {
    private static final Logger LOGGER = Logger.getLogger(OperatorParser.class);
    private static final String MSG_PROBLEM_OBTAINING_RESOURCE = "Problem encountered while obtaining resources for ";
    private final Deque<GraphicState> graphicStateStack = new ArrayDeque<GraphicState>();
    private final GraphicState graphicState = new GraphicState();

    OperatorParser() {
    }

    void parseOperator(List<Operator> operators, org.apache.pdfbox.contentstream.operator.Operator pdfBoxOperator, PDResources resources, List<COSBase> arguments) throws CloneNotSupportedException {
        String operatorName;
        switch (operatorName = pdfBoxOperator.getName()) {
            case "d": {
                operators.add(new PBOp_d(arguments));
                break;
            }
            case "gs": {
                this.addExtGState(operators, resources, arguments);
                break;
            }
            case "i": {
                operators.add(new PBOp_i(arguments));
                break;
            }
            case "J": {
                operators.add(new PBOp_J_line_cap(arguments));
                break;
            }
            case "j": {
                operators.add(new PBOp_j_line_join(arguments));
                break;
            }
            case "M": {
                operators.add(new PBOp_M_miter_limit(arguments));
                break;
            }
            case "ri": {
                operators.add(new PBOp_ri(arguments));
                break;
            }
            case "w": {
                operators.add(new PBOp_w_line_width(arguments));
                break;
            }
            case "BMC": {
                operators.add(new PBOp_BMC(arguments));
                break;
            }
            case "BDC": {
                operators.add(new PBOp_BDC(arguments));
                break;
            }
            case "EMC": {
                operators.add(new PBOp_EMC(arguments));
                break;
            }
            case "MP": {
                operators.add(new PBOp_MP(arguments));
                break;
            }
            case "DP": {
                operators.add(new PBOp_DP(arguments));
                break;
            }
            case "W": {
                operators.add(new PBOp_W_clip(arguments));
                break;
            }
            case "W*": {
                operators.add(new PBOp_WStar(arguments));
                break;
            }
            case "G": {
                this.graphicState.setStrokeColorSpace((PDColorSpace)PDDeviceGray.INSTANCE);
                operators.add(new PBOpColor(arguments));
                break;
            }
            case "g": {
                this.graphicState.setFillColorSpace((PDColorSpace)PDDeviceGray.INSTANCE);
                operators.add(new PBOpColor(arguments));
                break;
            }
            case "RG": {
                this.graphicState.setStrokeColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
                operators.add(new PBOpColor(arguments));
                break;
            }
            case "rg": {
                this.graphicState.setFillColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
                operators.add(new PBOpColor(arguments));
                break;
            }
            case "K": {
                this.graphicState.setStrokeColorSpace((PDColorSpace)PDDeviceCMYK.INSTANCE);
                operators.add(new PBOpColor(arguments));
                break;
            }
            case "k": {
                this.graphicState.setFillColorSpace((PDColorSpace)PDDeviceCMYK.INSTANCE);
                operators.add(new PBOpColor(arguments));
                break;
            }
            case "CS": {
                this.graphicState.setStrokeColorSpace(OperatorParser.getColorSpaceFromResources(resources, OperatorParser.getLastCOSName(arguments)));
                operators.add(new PBOpColor(arguments));
                break;
            }
            case "cs": {
                this.graphicState.setFillColorSpace(OperatorParser.getColorSpaceFromResources(resources, OperatorParser.getLastCOSName(arguments)));
                operators.add(new PBOpColor(arguments));
                break;
            }
            case "SCN": {
                this.setPatternColorSpace(operators, this.graphicState.getStrokeColorSpace(), resources, arguments);
                break;
            }
            case "scn": {
                this.setPatternColorSpace(operators, this.graphicState.getFillColorSpace(), resources, arguments);
                break;
            }
            case "SC": {
                operators.add(new PBOpColor(arguments));
                break;
            }
            case "sc": {
                operators.add(new PBOpColor(arguments));
                break;
            }
            case "ET": 
            case "BT": {
                operators.add(new PBOpTextObject(arguments));
                break;
            }
            case "Td": {
                operators.add(new PBOp_Td(arguments));
                break;
            }
            case "TD": {
                operators.add(new PBOp_TD_Big(arguments));
                break;
            }
            case "Tm": {
                operators.add(new PBOp_Tm(arguments));
                break;
            }
            case "T*": {
                operators.add(new PBOpTextPosition(arguments));
                break;
            }
            case "Tj": {
                operators.add(new PBOp_Tj(arguments, this.graphicState.clone()));
                break;
            }
            case "TJ": {
                operators.add(new PBOp_TJ_Big(arguments, this.graphicState.clone()));
                break;
            }
            case "'": {
                operators.add(new PBOp_Quote(arguments, this.graphicState.clone()));
                break;
            }
            case "\"": {
                operators.add(new PBOp_DoubleQuote(arguments, this.graphicState.clone()));
                break;
            }
            case "Tz": {
                operators.add(new PBOp_Tz(arguments));
                break;
            }
            case "Tr": {
                this.graphicState.setRenderingMode(OperatorParser.getRenderingMode(arguments));
                operators.add(new PBOp_Tr(arguments));
                break;
            }
            case "Tf": {
                this.graphicState.setFont(OperatorParser.getFontFromResources(resources, OperatorParser.getFirstCOSName(arguments)));
                operators.add(new PBOp_Tf(arguments));
                break;
            }
            case "Tc": {
                operators.add(new PBOp_Tc(arguments));
                break;
            }
            case "Tw": {
                operators.add(new PBOp_Tw(arguments));
                break;
            }
            case "TL": {
                operators.add(new PBOp_Tl(arguments));
                break;
            }
            case "Ts": {
                operators.add(new PBOp_Ts(arguments));
                break;
            }
            case "d0": {
                operators.add(new PBOp_d0(arguments));
                break;
            }
            case "d1": {
                operators.add(new PBOp_d1(arguments));
                break;
            }
            case "BI": {
                OperatorParser.addInlineImage(operators, pdfBoxOperator, resources, arguments);
                break;
            }
            case "BX": {
                operators.add(new PBOp_BX(arguments));
                break;
            }
            case "EX": {
                operators.add(new PBOp_EX(arguments));
                break;
            }
            case "c": {
                operators.add(new PBOp_c(arguments));
                break;
            }
            case "h": {
                operators.add(new PBOp_h(arguments));
                break;
            }
            case "l": {
                operators.add(new PBOp_l(arguments));
                break;
            }
            case "m": {
                operators.add(new PBOp_m_moveto(arguments));
                break;
            }
            case "re": {
                operators.add(new PBOp_re(arguments));
                break;
            }
            case "v": {
                operators.add(new PBOp_v(arguments));
                break;
            }
            case "y": {
                operators.add(new PBOp_y(arguments));
                break;
            }
            case "b": {
                operators.add(new PBOp_b_closepath_fill_stroke(arguments, this.graphicState.getStrokeColorSpace(), this.graphicState.getFillColorSpace(), this.graphicState.getPattern()));
                break;
            }
            case "B": {
                operators.add(new PBOp_B_fill_stroke(arguments, this.graphicState.getStrokeColorSpace(), this.graphicState.getFillColorSpace(), this.graphicState.getPattern()));
                break;
            }
            case "b*": {
                operators.add(new PBOp_bstar_closepath_eofill_stroke(arguments, this.graphicState.getStrokeColorSpace(), this.graphicState.getFillColorSpace(), this.graphicState.getPattern()));
                break;
            }
            case "B*": {
                operators.add(new PBOp_BStar_eofill_stroke(arguments, this.graphicState.getStrokeColorSpace(), this.graphicState.getFillColorSpace(), this.graphicState.getPattern()));
                break;
            }
            case "f": {
                operators.add(new PBOp_f_fill(arguments, this.graphicState.getFillColorSpace(), this.graphicState.getPattern()));
                break;
            }
            case "F": {
                operators.add(new PBOp_F_fill_obsolete(arguments, this.graphicState.getFillColorSpace(), this.graphicState.getPattern()));
                break;
            }
            case "f*": {
                operators.add(new PBOp_FStar(arguments, this.graphicState.getFillColorSpace(), this.graphicState.getPattern()));
                break;
            }
            case "n": {
                operators.add(new PBOp_n(arguments));
                break;
            }
            case "s": {
                operators.add(new PBOp_s_close_stroke(arguments, this.graphicState.getStrokeColorSpace(), this.graphicState.getPattern()));
                break;
            }
            case "S": {
                operators.add(new PBOp_S_stroke(arguments, this.graphicState.getStrokeColorSpace(), this.graphicState.getPattern()));
                break;
            }
            case "sh": {
                operators.add(new PBOp_sh(arguments, OperatorParser.getShadingFromResources(resources, OperatorParser.getLastCOSName(arguments))));
                break;
            }
            case "cm": {
                operators.add(new PBOp_cm(arguments));
                break;
            }
            case "Q": {
                if (!this.graphicStateStack.isEmpty()) {
                    this.graphicState.copyProperties(this.graphicStateStack.pop());
                }
                operators.add(new PBOp_Q_grestore(arguments));
                break;
            }
            case "q": {
                this.graphicStateStack.push(this.graphicState.clone());
                operators.add(new PBOp_q_gsave(arguments, this.graphicStateStack.size()));
                break;
            }
            case "Do": {
                operators.add(new PBOp_Do(arguments, OperatorParser.getXObjectFromResources(resources, OperatorParser.getLastCOSName(arguments))));
                break;
            }
            default: {
                operators.add(new PBOp_Undefined(arguments));
            }
        }
    }

    private void setPatternColorSpace(List<Operator> operators, PDColorSpace colorSpace, PDResources resources, List<COSBase> arguments) {
        if (colorSpace != null && "Pattern".equals(colorSpace.getName())) {
            this.graphicState.setPattern(OperatorParser.getPatternFromResources(resources, OperatorParser.getLastCOSName(arguments)));
        }
        operators.add(new PBOpColor(arguments));
    }

    private void addExtGState(List<Operator> operators, PDResources resources, List<COSBase> arguments) {
        PDExtendedGraphicsState extGState = OperatorParser.getExtGStateFromResources(resources, OperatorParser.getLastCOSName(arguments));
        this.graphicState.copyPropertiesFromExtGState(extGState);
        operators.add(new PBOp_gs(arguments, extGState));
    }

    private static void addInlineImage(List<Operator> operators, org.apache.pdfbox.contentstream.operator.Operator pdfBoxOperator, PDResources resources, List<COSBase> arguments) {
        if (pdfBoxOperator.getImageParameters() != null && pdfBoxOperator.getImageData() != null) {
            arguments.add((COSBase)pdfBoxOperator.getImageParameters());
            operators.add(new PBOp_BI(new ArrayList<COSBase>()));
            operators.add(new PBOp_ID(arguments));
            operators.add(new PBOp_EI(arguments, pdfBoxOperator.getImageData(), resources));
        }
    }

    private static COSName getFirstCOSName(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.isEmpty() ? null : arguments.get(0);
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private static COSName getLastCOSName(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.isEmpty() ? null : arguments.get(arguments.size() - 1);
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private static PDXObject getXObjectFromResources(PDResources resources, COSName xobject) {
        try {
            return resources.getXObject(xobject);
        }
        catch (IOException e) {
            LOGGER.error((Object)(MSG_PROBLEM_OBTAINING_RESOURCE + xobject + ". " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private static PDColorSpace getColorSpaceFromResources(PDResources resources, COSName colorSpace) {
        try {
            return resources.getColorSpace(colorSpace);
        }
        catch (IOException e) {
            LOGGER.error((Object)(MSG_PROBLEM_OBTAINING_RESOURCE + colorSpace + ". " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private static PDShading getShadingFromResources(PDResources resources, COSName shading) {
        try {
            return resources.getShading(shading);
        }
        catch (IOException e) {
            LOGGER.error((Object)(MSG_PROBLEM_OBTAINING_RESOURCE + shading + ". " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private static PDExtendedGraphicsState getExtGStateFromResources(PDResources resources, COSName extGState) {
        return resources.getExtGState(extGState);
    }

    private static PDFont getFontFromResources(PDResources resources, COSName font) {
        try {
            return resources.getFont(font);
        }
        catch (IOException e) {
            LOGGER.error((Object)(MSG_PROBLEM_OBTAINING_RESOURCE + font + ". " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private static RenderingMode getRenderingMode(List<COSBase> arguments) {
        COSBase renderingMode;
        if (!arguments.isEmpty() && (renderingMode = arguments.get(0)) instanceof COSInteger) {
            try {
                RenderingMode rMode = RenderingMode.fromInt((int)((COSInteger)renderingMode).intValue());
                return rMode;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.error((Object)("Rendering mode value is incorrect : " + renderingMode));
                LOGGER.error((Object)e);
            }
        }
        return RenderingMode.FILL;
    }

    private static PDAbstractPattern getPatternFromResources(PDResources resources, COSName pattern) {
        try {
            return resources.getPattern(pattern);
        }
        catch (IOException e) {
            LOGGER.error((Object)(MSG_PROBLEM_OBTAINING_RESOURCE + pattern + ". " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

