/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.colors;

import org.apache.pdfbox.pdmodel.graphics.color.PDCalGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDLab;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDCalGray;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDCalRGB;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDDeviceCMYK;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDDeviceGray;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDDeviceN;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDDeviceRGB;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDICCBased;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDIndexed;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDLab;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDSeparation;
import org.verapdf.model.impl.pb.pd.pattern.PBoxPDShadingPattern;
import org.verapdf.model.impl.pb.pd.pattern.PBoxPDTilingPattern;
import org.verapdf.model.pdlayer.PDPattern;

public class ColorSpaceFactory {
    public static final String CAL_GRAY = "CalGray";
    public static final String CAL_RGB = "CalRGB";
    public static final String DEVICE_CMYK = "DeviceCMYK";
    public static final String DEVICE_GRB = "DeviceRGB";
    public static final String DEVICE_GRAY = "DeviceGray";
    public static final String DEVICE_N = "DeviceN";
    public static final String ICC_BASED = "ICCBased";
    public static final String LAB = "Lab";
    public static final String SEPARATION = "Separation";
    public static final String INDEXED = "Indexed";
    public static final String PATTERN = "Pattern";

    private ColorSpaceFactory() {
    }

    public static org.verapdf.model.pdlayer.PDColorSpace getColorSpace(PDColorSpace colorSpace) {
        return ColorSpaceFactory.getColorSpace(colorSpace, null);
    }

    public static org.verapdf.model.pdlayer.PDColorSpace getColorSpace(PDColorSpace colorSpace, PDAbstractPattern pattern) {
        if (colorSpace == null) {
            return null;
        }
        switch (colorSpace.getName()) {
            case "CalGray": {
                return new PBoxPDCalGray((PDCalGray)colorSpace);
            }
            case "CalRGB": {
                return new PBoxPDCalRGB((PDCalRGB)colorSpace);
            }
            case "DeviceN": {
                return new PBoxPDDeviceN((PDDeviceN)colorSpace);
            }
            case "DeviceCMYK": {
                return PBoxPDDeviceCMYK.getInstance();
            }
            case "DeviceRGB": {
                return PBoxPDDeviceRGB.getInstance();
            }
            case "DeviceGray": {
                return PBoxPDDeviceGray.getInstance();
            }
            case "ICCBased": {
                return new PBoxPDICCBased((PDICCBased)colorSpace);
            }
            case "Lab": {
                return new PBoxPDLab((PDLab)colorSpace);
            }
            case "Separation": {
                return new PBoxPDSeparation((PDSeparation)colorSpace);
            }
            case "Indexed": {
                return new PBoxPDIndexed((PDIndexed)colorSpace);
            }
            case "Pattern": {
                return ColorSpaceFactory.getPattern(pattern);
            }
        }
        return null;
    }

    public static PDPattern getPattern(PDAbstractPattern pattern) {
        if (pattern != null && pattern.getPatternType() == 2) {
            return new PBoxPDShadingPattern((PDShadingPattern)pattern);
        }
        if (pattern != null && pattern.getPatternType() == 1) {
            return new PBoxPDTilingPattern((PDTilingPattern)pattern);
        }
        return null;
    }
}

