/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.Terminal;
import jline.UnsupportedTerminal;
import jline.console.ConsoleReader;
import jline.console.completer.FileNameCompleter;
import jline.internal.Log;

public class Console {
    private static final Logger logger = Logger.getLogger(Console.class.getName());
    private static final java.io.Console console = System.console();
    private ConsoleReader consoleReader;
    private boolean consoleReaderFailed = false;
    private final FileNameCompleter fileNameCompleter = new FileNameCompleter();

    public Console() {
        try {
            Log.setOutput(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            }));
            this.consoleReader = new ConsoleReader("IzPack", new FileInputStream(FileDescriptor.in), System.out, null);
            this.consoleReader.setHandleUserInterrupt(true);
            Terminal terminal = this.consoleReader.getTerminal();
            if (terminal == null || terminal instanceof UnsupportedTerminal) {
                this.consoleReader.shutdown();
                throw new Throwable("Terminal not initialized");
            }
        }
        catch (Throwable t) {
            this.consoleReaderFailed = true;
            logger.log(Level.WARNING, "Cannot initialize the console reader. Default to regular input stream.", t);
        }
    }

    public String readLine() throws IOException {
        if (this.consoleReaderFailed) {
            return this.readLineDefaultInput();
        }
        return this.consoleReader.readLine();
    }

    public void print(String message) {
        if (console != null) {
            console.printf("%s", message);
            console.flush();
        } else {
            System.out.print(message);
        }
    }

    public void println() {
        if (console != null) {
            console.printf("\n", new Object[0]);
        } else {
            System.out.println();
        }
    }

    public void println(String message) {
        if (console != null) {
            console.printf("%s\n", message);
        } else {
            System.out.println(message);
        }
    }

    public int prompt(String prompt, int min, int max, int eof) {
        return this.prompt(prompt, min, max, min - 1, eof);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int prompt(String prompt, int min, int max, int defaultValue, int eof) {
        int result = min - 1;
        try {
            do {
                this.println(prompt);
                String value = this.readLine();
                if (value == null) return eof;
                if ((value = value.trim()).equals("") && defaultValue >= min) {
                    return defaultValue;
                }
                try {
                    result = Integer.valueOf(value);
                }
                catch (NumberFormatException ignore) {}
            } while (result < min || result > max);
            return result;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return eof;
        }
    }

    public String promptLocation(String prompt, String eof) {
        return this.promptLocation(prompt, "", eof);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String promptLocation(String prompt, String defaultValue, String eof) {
        String result;
        if (this.consoleReaderFailed) {
            return this.prompt(prompt, defaultValue, eof);
        }
        this.consoleReader.addCompleter(this.fileNameCompleter);
        this.println(prompt);
        try {
            result = this.consoleReader.readLine().trim();
            if (result != null) {
                if (result.startsWith("~")) {
                    result = result.replace("~", System.getProperty("user.home"));
                }
                if (result.endsWith(File.separator) && result.length() > 1) {
                    result = result.substring(0, result.length() - 1);
                }
                if (result.isEmpty()) {
                    result = defaultValue;
                }
            }
        }
        catch (IOException e) {
            result = eof;
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        finally {
            this.consoleReader.removeCompleter(this.fileNameCompleter);
        }
        return result;
    }

    public String promptPassword(String prompt, String eof) {
        return this.promptPassword(prompt, "", eof);
    }

    public String promptPassword(String prompt, String defaultValue, String eof) {
        if (this.consoleReaderFailed) {
            try {
                char[] passwd = this.readPasswordDefaultInput(defaultValue, "%s\n", prompt);
                return new String(passwd);
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        String result = "";
        String backspace = "\b \b";
        String echoCharacter = "*";
        StringBuilder stringBuilder = new StringBuilder();
        this.println(prompt);
        boolean submitted = false;
        try {
            block8: while (!submitted) {
                int ch = this.consoleReader.readCharacter();
                switch (ch) {
                    case -1: 
                    case 10: 
                    case 13: {
                        this.println("");
                        result = stringBuilder.toString();
                        submitted = true;
                        continue block8;
                    }
                    case 8: 
                    case 127: {
                        if (stringBuilder.length() <= 0) continue block8;
                        this.print(backspace);
                        stringBuilder.setLength(stringBuilder.length() - 1);
                        continue block8;
                    }
                }
                this.print(echoCharacter);
                stringBuilder.append((char)ch);
            }
        }
        catch (IOException e) {
            result = eof;
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        if (result.isEmpty()) {
            result = defaultValue;
        }
        return result;
    }

    public String prompt(String prompt, String eof) {
        return this.prompt(prompt, "", eof);
    }

    public String prompt(String prompt, String defaultValue, String eof) {
        String result;
        try {
            this.println(prompt);
            result = this.readLine();
            if (result == null) {
                result = eof;
            } else if (result.equals("")) {
                result = defaultValue;
            }
        }
        catch (IOException e) {
            result = eof;
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return result;
    }

    public String prompt(String prompt, String[] values, String eof) {
        String input;
        block0: while ((input = this.prompt(prompt, eof)) != null && !input.equals(eof)) {
            String[] arr$ = values;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ >= len$) continue block0;
                String value = arr$[i$];
                if (value.equalsIgnoreCase(input)) {
                    return value;
                }
                ++i$;
            }
            break;
        }
        return input;
    }

    private String readLineDefaultInput() throws IOException {
        return console.readLine();
    }

    private char[] readPasswordDefaultInput(String defaultValue, String format, Object ... args) throws IOException {
        char[] result;
        if (console != null) {
            result = console.readPassword(format, args);
            if (result.length == 0) {
                result = defaultValue.toCharArray();
            }
        } else {
            result = this.readLine().toCharArray();
        }
        return result;
    }

    public void useDefaultInput() {
        this.consoleReaderFailed = true;
    }
}

