/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.resource;

import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.core.resource.AbstractResources;
import com.izforge.izpack.core.resource.LocaleHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;

public class ResourceManager
extends AbstractResources {
    private Locales locales;
    public final String resourceBasePathDefaultConstant = "/resources/";
    private String resourceBasePath = "/resources/";

    public ResourceManager() {
        this(ClassLoader.getSystemClassLoader());
    }

    public ResourceManager(ClassLoader loader) {
        super(loader);
    }

    public void setLocales(Locales locales) {
        this.locales = locales;
    }

    @Deprecated
    public void setDefaultOrResourceBasePath(String aDefaultBasePath) {
        if (null != aDefaultBasePath) {
            this.setResourceBasePath(aDefaultBasePath);
        } else {
            this.setResourceBasePath("/resources/");
        }
    }

    @Deprecated
    public boolean isResourceExist(String resource) {
        return this.getLanguageResourceString(resource) != null;
    }

    @Override
    public InputStream getInputStream(String resource) {
        resource = this.getLanguageResourceString(resource);
        return super.getInputStream(resource);
    }

    @Override
    public URL getURL(String name) {
        return this.getResource(this.getLanguageResourceString(name));
    }

    @Deprecated
    public InputStream getInputStream(String resource, InputStream defaultValue) {
        String resourcepath = this.getLanguageResourceString(resource);
        if (resourcepath == null) {
            return defaultValue;
        }
        return this.getInputStream(resourcepath);
    }

    @Deprecated
    public URL getLocalizedURL(String resource) {
        return this.getResource(this.getLanguageResourceString(resource));
    }

    @Deprecated
    public String getTextResource(String resource, String encoding) throws IOException {
        return this.readString(resource, encoding);
    }

    @Deprecated
    public String getTextResource(String resource) throws IOException {
        return this.getTextResource(resource, null);
    }

    @Deprecated
    public ImageIcon getImageIconResource(String resource, String ... fallback) {
        return this.getImageIcon(resource, fallback);
    }

    @Deprecated
    public void setLocale(String locale) {
        this.locales.setLocale(locale);
    }

    public String getLocale() {
        if (this.locales != null) {
            Locale locale = this.locales.getLocale();
            return locale != null ? locale.getISO3Language() : null;
        }
        return null;
    }

    public String getResourceBasePath() {
        return this.resourceBasePath;
    }

    public void setResourceBasePath(String resourceBasePath) {
        this.resourceBasePath = resourceBasePath;
    }

    @Deprecated
    public InputStream getLangPack(String localeISO3) {
        return this.getInputStream("langpacks/" + localeISO3 + ".xml");
    }

    @Deprecated
    public InputStream getLangPack() {
        return this.getLangPack(this.locales.getLocale().getISO3Language());
    }

    @Deprecated
    public List<String> getAvailableLangPacks() {
        return (List)this.getObject("langpacks.info");
    }

    @Override
    protected String resolveName(String name) {
        name = name.charAt(0) == '/' ? name : this.getResourceBasePath() + name;
        return super.resolveName(name);
    }

    private String getLanguageResourceString(String resource) {
        String resourcePath;
        Locale locale = this.locales != null ? this.locales.getLocale() : null;
        String country = null;
        String language = null;
        if (locale != null) {
            country = LocaleHelper.getISO3Country(locale);
            language = LocaleHelper.getISO3Language(locale);
        }
        String string = resourcePath = country != null ? resource + "_" + country.toLowerCase() : null;
        if (resourcePath != null && this.getResource(resourcePath) != null) {
            return resourcePath;
        }
        String string2 = resourcePath = language != null ? resource + "_" + language : null;
        if (resourcePath != null && this.getResource(resourcePath) != null) {
            return resourcePath;
        }
        if (this.getResource(resource) != null) {
            return resource;
        }
        if (resourcePath != null) {
            throw new ResourceNotFoundException("Cannot find named resource: '" + resource + "' AND '" + resourcePath + "'");
        }
        throw new ResourceNotFoundException("Cannot find named resource: '" + resource + "'");
    }
}

