/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.panel;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.DynamicInstallerRequirementValidator;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.installer.panel.PanelView;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPanelView<T>
implements PanelView<T> {
    private final Panel panel;
    private final Class<T> viewClass;
    private final ObjectFactory factory;
    private int index;
    private T view;
    private boolean visible = true;
    private List<DataValidator> validators = new ArrayList<DataValidator>();
    private final InstallData installData;
    private final List<PanelAction> preActivationActions = new ArrayList<PanelAction>();
    private final List<PanelAction> preValidationActions = new ArrayList<PanelAction>();
    private final List<PanelAction> postValidationActions = new ArrayList<PanelAction>();
    private static final Logger logger = Logger.getLogger(AbstractPanelView.class.getName());

    public AbstractPanelView(Panel panel, Class<T> viewClass, ObjectFactory factory, InstallData installData) {
        this.panel = panel;
        this.viewClass = viewClass;
        this.factory = factory;
        this.installData = installData;
    }

    @Override
    public String getPanelId() {
        return this.panel.getPanelId();
    }

    @Override
    public Panel getPanel() {
        return this.panel;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public T getView() {
        if (this.view == null) {
            this.executePreConstructionActions();
            this.view = this.createView(this.panel, this.viewClass);
            List<String> dataValidatorClassNames = this.panel.getValidators();
            for (String dataValidatorClassName : dataValidatorClassNames) {
                this.validators.add(this.factory.create(dataValidatorClassName, DataValidator.class, this.panel, this.view));
            }
            this.addActions(this.panel.getPreActivationActions(), this.preActivationActions, PanelAction.ActionStage.preactivate);
            this.addActions(this.panel.getPreValidationActions(), this.preValidationActions, PanelAction.ActionStage.prevalidate);
            this.addActions(this.panel.getPostValidationActions(), this.postValidationActions, PanelAction.ActionStage.postvalidate);
            this.initialise(this.view, this.panel, this.installData);
        }
        return this.view;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isValid() {
        return this.isValid(true);
    }

    @Override
    public boolean isValid(boolean refreshVariables) {
        boolean result = false;
        if (refreshVariables) {
            this.installData.getVariables().refresh();
        }
        this.executePreValidationActions();
        List<DynamicInstallerRequirementValidator> conditions = this.installData.getDynamicInstallerRequirements();
        if (conditions == null || this.validateDynamicConditions()) {
            result = this.validators.size() == 0 || this.validateData();
        }
        this.executePostValidationActions();
        return result;
    }

    @Override
    public void saveData() {
    }

    @Override
    public boolean canShow() {
        boolean visible;
        String panelId = this.panel.getPanelId();
        this.installData.refreshVariables();
        if (this.panel.hasCondition()) {
            visible = this.installData.getRules().isConditionTrue(this.panel.getCondition());
            logger.fine("Panel '" + this.getPanelId() + "' depending on condition '" + this.panel.getCondition() + "' " + (visible ? "can be shown" : "will be skipped"));
        } else {
            visible = this.installData.getRules().canShowPanel(panelId, this.installData.getVariables());
            logger.fine("Panel '" + this.getPanelId() + "' " + (visible ? "can be shown" : "will be skipped"));
        }
        if (!visible && this.panel.isDisplayHidden()) {
            visible = true;
            logger.fine("Panel '" + this.getPanelId() + "' depending on displayHidden can be shown read-only");
        }
        if (!visible && this.panel.hasDisplayHiddenCondition()) {
            visible = this.installData.getRules().isConditionTrue(this.panel.getDisplayHiddenCondition());
            this.panel.setDisplayHidden(visible);
            logger.fine("Panel '" + this.getPanelId() + "' depending on displayHiddenCondition '" + this.panel.getDisplayHiddenCondition() + "' " + (visible ? "can be shown read-only" : "will be skipped"));
        }
        if (visible && !this.panel.isReadonly() && this.panel.hasReadonlyCondition()) {
            boolean readonly = this.installData.getRules().isConditionTrue(this.panel.getReadonlyCondition());
            this.panel.setReadonly(readonly);
            logger.fine("Panel '" + this.getPanelId() + "' depending on readonlyCondition '" + this.panel.getReadonlyCondition() + "' " + (readonly ? "is forcibly read-only" : "is editable"));
        }
        return visible;
    }

    public void executePreActivationActions() {
        this.execute(this.preActivationActions);
    }

    public void executePreValidationActions() {
        this.execute(this.preValidationActions);
    }

    public void executePostValidationActions() {
        this.execute(this.postValidationActions);
    }

    protected abstract AbstractUIHandler getHandler();

    protected T createView(Panel panel, Class<T> viewClass) {
        return this.factory.create(panel.getClassName(), viewClass, panel, this);
    }

    protected void initialise(T view, Panel panel, InstallData installData) {
    }

    protected boolean validateDynamicConditions() {
        boolean result = true;
        try {
            for (DynamicInstallerRequirementValidator validator : this.installData.getDynamicInstallerRequirements()) {
                if (this.isValid(validator, this.installData)) continue;
                result = false;
                break;
            }
        }
        catch (Throwable exception) {
            logger.log(Level.WARNING, "Panel " + this.getPanelId() + ": Could not validate dynamic conditions", exception);
            result = false;
        }
        return result;
    }

    protected boolean validateData() {
        boolean result = true;
        DataValidator[] validatorArray = this.validators.toArray(new DataValidator[0]);
        for (int i = 0; i < validatorArray.length; ++i) {
            DataValidator validator = validatorArray[i];
            if (this.isValid(validator, i, this.installData)) continue;
            result = false;
            break;
        }
        return result;
    }

    private boolean isValid(DataValidator validator, Integer index, InstallData installData) {
        Condition dataValidatorCondition;
        String dataValidatorConditionId = this.panel.getValidatorCondition(index);
        if (dataValidatorConditionId != null && !(dataValidatorCondition = installData.getRules().getCondition(dataValidatorConditionId)).isTrue()) {
            logger.fine("Panel " + this.getPanelId() + ": Skip validation (" + validator.getClass().getName() + ")");
            return true;
        }
        return this.isValid(validator, installData);
    }

    private boolean isValid(DataValidator validator, InstallData installData) {
        boolean result = false;
        DataValidator.Status status = validator.validateData(installData);
        logger.fine("Panel " + this.getPanelId() + ": Data validation status=" + (Object)((Object)status) + " (" + validator.getClass().getName() + ")");
        if (status == DataValidator.Status.OK) {
            result = true;
        } else if (status == DataValidator.Status.WARNING) {
            String message = this.getMessage(validator.getWarningMessageId(), true);
            if (message == null) {
                logger.warning("Panel " + this.getPanelId() + ": No warning message for validator " + validator.getClass().getName());
            }
            result = this.isWarningValid(message, validator.getDefaultAnswer());
        } else {
            String message = this.getMessage(validator.getErrorMessageId(), true);
            if (message == null) {
                logger.warning("Panel " + this.getPanelId() + ": No error message for validator " + validator.getClass().getName());
                message = "Validation error";
            }
            this.getHandler().emitError(this.getMessage("data.validation.error.title"), message);
        }
        return result;
    }

    protected boolean isWarningValid(String message, boolean defaultAnswer) {
        boolean result = false;
        if (message != null) {
            if (this.getHandler().emitWarning(this.getMessage("data.validation.warning.title"), message)) {
                result = true;
                logger.fine("Panel " + this.getPanelId() + ": User decided to skip validation warning");
            }
        } else {
            logger.fine("Panel " + this.getPanelId() + ": No warning message available, using default answer=" + defaultAnswer);
            result = defaultAnswer;
        }
        return result;
    }

    protected ObjectFactory getFactory() {
        return this.factory;
    }

    protected String getMessage(String id) {
        return this.getMessage(id, false);
    }

    private void execute(List<PanelAction> actions) {
        AbstractUIHandler handler = this.getHandler();
        for (PanelAction action : actions) {
            action.executeAction(this.installData, handler);
        }
    }

    private void executePreConstructionActions() {
        List<PanelActionConfiguration> configurations = this.panel.getPreConstructionActions();
        if (configurations != null) {
            for (PanelActionConfiguration config : configurations) {
                PanelAction action = this.factory.create(config.getActionClassName(), PanelAction.class, new Object[]{this.panel, PanelAction.ActionStage.preconstruct});
                action.initialize(config);
                action.executeAction(this.installData, null);
            }
        }
    }

    private void addActions(List<PanelActionConfiguration> configurations, List<PanelAction> actions, PanelAction.ActionStage stage) {
        if (configurations != null) {
            for (PanelActionConfiguration config : configurations) {
                PanelAction action = this.factory.create(config.getActionClassName(), PanelAction.class, new Object[]{this.panel, this.view, stage});
                action.initialize(config);
                actions.add(action);
            }
        }
    }

    private String getMessage(String id, boolean replace) {
        String message = null;
        if (id != null) {
            Messages messages = this.installData.getMessages();
            message = messages.get(id, new Object[0]);
            if (replace) {
                message = this.installData.getVariables().replace(message);
            }
        }
        return message;
    }

    protected final IXMLElement createPanelRootRecord() {
        XMLElementImpl panelRoot = new XMLElementImpl(this.panel.getClassName(), this.installData.getInstallationRecord());
        String panelId = this.panel.getPanelId();
        if (panelId != null) {
            panelRoot.setAttribute("id", panelId);
        }
        return panelRoot;
    }
}

