/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.event.ProgressNotifiers;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.event.AbstractProgressInstallerListener;
import com.izforge.izpack.event.AntAction;
import com.izforge.izpack.event.AntLogLevel;
import com.izforge.izpack.event.AntSeverity;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.helper.SpecHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AntActionInstallerListener
extends AbstractProgressInstallerListener {
    public static final String SPEC_FILE_NAME = "AntActionsSpec.xml";
    private final Map<String, Map<Object, List<AntAction>>> actions = new HashMap<String, Map<Object, List<AntAction>>>();
    private List<AntAction> uninstActions = new ArrayList<AntAction>();
    private VariableSubstitutor replacer;
    private UninstallData uninstallData;
    private SpecHelper spec;
    private static final Logger logger = Logger.getLogger(AntActionInstallerListener.class.getName());

    public AntActionInstallerListener(VariableSubstitutor replacer, Resources resources, InstallData installData, UninstallData uninstallData, ProgressNotifiers notifiers) {
        super(installData, notifiers);
        this.replacer = replacer;
        this.uninstallData = uninstallData;
        this.spec = new SpecHelper(resources);
    }

    @Override
    public void beforePacks(List<Pack> packs) throws InstallerException {
        try {
            this.spec.readSpec(SPEC_FILE_NAME, this.replacer);
        }
        catch (Exception exception) {
            throw new IzPackException("Failed to read: AntActionsSpec.xml", exception);
        }
        if (this.spec.getSpec() == null) {
            return;
        }
        for (Pack pack : packs) {
            IXMLElement packElement = this.spec.getPackForName(pack.getName());
            if (packElement == null) continue;
            HashMap packActions = new HashMap();
            packActions.put("beforepack", new ArrayList());
            packActions.put("afterpack", new ArrayList());
            packActions.put("beforepacks", new ArrayList());
            packActions.put("afterpacks", new ArrayList());
            List<IXMLElement> antCallEntries = packElement.getChildrenNamed("antcall");
            if (antCallEntries != null && antCallEntries.size() >= 1) {
                for (IXMLElement antCallEntry : antCallEntries) {
                    AntAction act = this.readAntCall(antCallEntry);
                    if (act == null) continue;
                    List antActions = (List)packActions.get(act.getOrder());
                    antActions.add(act);
                }
                if (!((List)packActions.get("afterpacks")).isEmpty()) {
                    this.setProgressNotifier();
                }
            }
            this.actions.put(pack.getName(), packActions);
        }
        for (Pack pack : packs) {
            String currentPack = pack.getName();
            this.performAllActions(currentPack, "beforepacks", null);
        }
    }

    @Override
    public void beforePack(Pack pack, int i) throws InstallerException {
        this.performAllActions(pack.getName(), "beforepack", null);
    }

    @Override
    public void afterPack(Pack pack, int i) throws InstallerException {
        this.performAllActions(pack.getName(), "afterpack", null);
    }

    @Override
    public void afterPacks(List<Pack> packs, ProgressListener listener) throws InstallerException {
        if (this.notifyProgress()) {
            int count = this.getActionCount(packs, "afterpacks");
            listener.nextStep(this.getMessage("AntAction.pack"), this.getProgressNotifierId(), count);
        }
        for (Pack pack : packs) {
            String currentPack = pack.getName();
            this.performAllActions(currentPack, "afterpacks", listener);
        }
        if (!this.uninstActions.isEmpty()) {
            this.uninstallData.addAdditionalData("antActions", this.uninstActions);
        }
    }

    private int getActionCount(List<Pack> packs, String order) {
        int result = 0;
        for (Pack pack : packs) {
            String currentPack = pack.getName();
            List<AntAction> actList = this.getActions(currentPack, order);
            if (actList == null) continue;
            result += actList.size();
        }
        return result;
    }

    protected List<AntAction> getActions(String packName, String order) {
        Map<Object, List<AntAction>> packActions = this.actions.get(packName);
        if (packActions == null || packActions.isEmpty()) {
            return null;
        }
        return packActions.get(order);
    }

    private void performAllActions(String packName, String order, ProgressListener listener) throws InstallerException {
        List<AntAction> actList = this.getActions(packName, order);
        if (actList == null || actList.isEmpty()) {
            return;
        }
        boolean notifyProgress = this.notifyProgress() && order.equals("afterpacks");
        logger.fine("Executing all " + order + " Ant actions of pack " + packName + " ...");
        RulesEngine rules = this.getInstallData().getRules();
        for (AntAction act : actList) {
            if (notifyProgress) {
                String message = act.getMessageID() != null ? this.getMessage(act.getMessageID()) : "";
                listener.progress(message);
            }
            try {
                String conditionId = act.getConditionId();
                if (conditionId == null || rules.isConditionTrue(conditionId)) {
                    act.performInstallAction();
                }
            }
            catch (IzPackException e) {
                act.throwBuildException(e);
            }
            if (act.getUninstallTargets().isEmpty()) continue;
            this.uninstActions.add(act);
        }
    }

    private AntAction readAntCall(IXMLElement el) {
        String msgId;
        File effectiveBuildFile;
        String effectiveBaseDir;
        String severityAttrValue;
        AntSeverity severity;
        if (el == null) {
            return null;
        }
        AntAction act = new AntAction();
        try {
            act.setOrder(this.spec.getRequiredAttribute(el, "order"));
            act.setUninstallOrder(el.getAttribute("uninstall_order", "beforedeletion"));
        }
        catch (Exception e) {
            throw new InstallerException(e);
        }
        act.setQuiet(this.spec.isAttributeYes(el, "quiet", false));
        act.setVerbose(this.spec.isAttributeYes(el, "verbose", false));
        if (!act.isQuiet() && !act.isVerbose()) {
            String logLevelAttrValue = el.getAttribute("loglevel");
            AntLogLevel logLevel = AntLogLevel.fromName(logLevelAttrValue);
            if (logLevel == null) {
                if (logLevelAttrValue != null) {
                    throw new InstallerException("Bad value for attribute loglevel");
                }
                logLevel = AntLogLevel.INFO;
            }
            act.setLogLevel(logLevel);
        }
        if ((severity = AntSeverity.fromName(severityAttrValue = el.getAttribute("severity"))) == null) {
            if (severityAttrValue != null) {
                throw new InstallerException("Bad value for attribute severity");
            }
            severity = AntSeverity.ERROR;
        }
        act.setSeverity(severity.getLevel());
        String buildDir = el.getAttribute("dir");
        if (buildDir != null) {
            buildDir = this.replacer.substitute(buildDir);
            act.setBuildDir(new File(this.replacer.substitute(buildDir)));
        }
        String buildFile = el.getAttribute("buildfile");
        act.setConditionId(el.getAttribute("condition"));
        File buildResourceFile = this.getBuildFileFromResource(this.spec, el);
        if (null == buildFile && null == buildResourceFile) {
            throw new InstallerException("Invalid AntActionsSpec.xml: either buildfile or buildresource must be specified");
        }
        if (null != buildFile && null != buildResourceFile) {
            throw new InstallerException("Invalid AntActionsSpec.xml: cannot specify both buildfile and buildresource");
        }
        InstallData installData = this.getInstallData();
        String string = effectiveBaseDir = buildDir != null ? buildDir : installData.getInstallPath();
        if (null != buildFile) {
            try {
                effectiveBuildFile = FileUtil.getAbsoluteFile(this.replacer.substitute(buildFile), effectiveBaseDir);
            }
            catch (Exception e) {
                effectiveBuildFile = FileUtil.getAbsoluteFile(buildFile, effectiveBaseDir);
            }
        } else {
            effectiveBuildFile = buildResourceFile;
        }
        act.setBuildFile(effectiveBuildFile);
        String str = el.getAttribute("logfile");
        if (str != null) {
            String logAppendValue = el.getAttribute("logfile_append");
            boolean logAppend = false;
            if (logAppendValue != null) {
                logAppend = Boolean.parseBoolean(logAppendValue);
            }
            try {
                act.setLogFile(FileUtil.getAbsoluteFile(this.replacer.substitute(str), installData.getInstallPath()), logAppend);
            }
            catch (Exception e) {
                act.setLogFile(FileUtil.getAbsoluteFile(str, installData.getInstallPath()), logAppend);
            }
        }
        if ((msgId = el.getAttribute("messageid")) != null && msgId.length() > 0) {
            act.setMessageID(msgId);
        }
        for (IXMLElement propEl : el.getChildrenNamed("propertyfile")) {
            act.addPropertyFile(this.spec.getRequiredAttribute(propEl, "path"));
        }
        for (IXMLElement propEl : el.getChildrenNamed("property")) {
            act.setProperty(this.spec.getRequiredAttribute(propEl, "name"), this.spec.getRequiredAttribute(propEl, "value"));
        }
        for (IXMLElement targEl : el.getChildrenNamed("target")) {
            act.addTarget(this.spec.getRequiredAttribute(targEl, "name"));
        }
        for (IXMLElement utargEl : el.getChildrenNamed("uninstall_target")) {
            act.addUninstallTarget(this.spec.getRequiredAttribute(utargEl, "name"));
        }
        if (null != buildResourceFile && act.getUninstallTargets().size() > 0) {
            this.addBuildResourceToUninstallerData(buildResourceFile);
        }
        return act;
    }

    private File getBuildFileFromResource(SpecHelper spec, IXMLElement el) {
        File buildResourceFile = null;
        String attr = el.getAttribute("buildresource");
        if (null != attr) {
            BufferedInputStream bis = new BufferedInputStream(spec.getResource(attr));
            BufferedOutputStream bos = null;
            try {
                int aByte;
                File tempFile = File.createTempFile("resource_" + attr, ".xml");
                tempFile.deleteOnExit();
                bos = new BufferedOutputStream(new FileOutputStream(tempFile));
                while (-1 != (aByte = bis.read())) {
                    bos.write(aByte);
                }
                buildResourceFile = tempFile;
            }
            catch (IOException x) {
                try {
                    throw new InstallerException("I/O error during writing resource " + attr + " to a temporary buildfile", x);
                }
                catch (Throwable throwable) {
                    FileUtils.close(bos);
                    FileUtils.close(bis);
                    throw throwable;
                }
            }
            FileUtils.close(bos);
            FileUtils.close(bis);
        }
        return buildResourceFile;
    }

    private void addBuildResourceToUninstallerData(File buildFile) throws InstallerException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)buildFile.length());
        BufferedInputStream bis = null;
        try {
            int aByte;
            bis = new BufferedInputStream(new FileInputStream(buildFile));
            while (-1 != (aByte = bis.read())) {
                bos.write(aByte);
            }
            byte[] content = bos.toByteArray();
            this.uninstallData.addAdditionalData("build_resource", content);
        }
        catch (Exception x) {
            try {
                throw new InstallerException("Failed to add buildfile_resource to uninstaller", x);
            }
            catch (Throwable throwable) {
                FileUtils.close(bis);
                FileUtils.close(bos);
                throw throwable;
            }
        }
        FileUtils.close(bis);
        FileUtils.close(bos);
    }
}

