/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackColor;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.util.PackHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class PacksModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3258128076746733110L;
    private static final transient Logger logger = Logger.getLogger(PacksModel.class.getName());
    protected List<Pack> packs;
    protected List<Pack> allPacks;
    protected List<Pack> hiddenPacks;
    protected List<Pack> packsToInstall;
    private Map<String, Pack> installedPacks;
    protected int[] checkValues;
    private Map<String, Pack> nameToPack;
    private Map<String, Integer> nameToRow;
    private InstallData installData;
    private Messages messages;
    protected RulesEngine rules;
    protected Variables variables;
    private boolean modifyInstallation;
    public final int PARTIAL_SELECTED = 2;
    public final int SELECTED = 1;
    public final int DESELECTED = 0;
    public final int REQUIRED_SELECTED = -1;
    public final int DEPENDENT_DESELECTED = -2;
    public final int REQUIRED_PARTIAL_SELECTED = -3;
    public final int REQUIRED_DESELECTED = -4;

    public PacksModel(InstallData idata) {
        this.installData = idata;
        this.rules = idata.getRules();
        try {
            this.messages = idata.getMessages().newMessages("packsLang.xml");
        }
        catch (ResourceNotFoundException ex) {
            this.messages = idata.getMessages();
        }
        this.variables = idata.getVariables();
        this.packsToInstall = idata.getSelectedPacks();
        this.modifyInstallation = Boolean.valueOf(idata.getVariable("modify.izpack.install"));
        this.installedPacks = this.loadInstallationInformation(this.modifyInstallation);
        this.packs = this.getVisiblePacks();
        this.hiddenPacks = this.getHiddenPacks();
        this.allPacks = idata.getAvailablePacks();
        this.nameToRow = this.getNametoRowMapping(this.packs);
        this.nameToPack = this.getNametoPackMapping(this.allPacks);
        this.packs = this.setPackProperties(this.packs, this.nameToPack);
        this.checkValues = this.initCheckValues(this.packs, this.packsToInstall);
        this.updateConditions(true);
        this.updatePacksToInstall();
    }

    private List<Pack> getHiddenPacks() {
        ArrayList<Pack> hiddenPacks = new ArrayList<Pack>();
        for (Pack availablePack : this.installData.getAvailablePacks()) {
            if (!availablePack.isHidden()) continue;
            hiddenPacks.add(availablePack);
        }
        return hiddenPacks;
    }

    public List<Pack> getVisiblePacks() {
        ArrayList<Pack> visiblePacks = new ArrayList<Pack>();
        for (Pack availablePack : this.installData.getAvailablePacks()) {
            if (availablePack.isHidden()) continue;
            visiblePacks.add(availablePack);
        }
        return visiblePacks;
    }

    private Map<String, Pack> getNametoPackMapping(List<Pack> packs) {
        HashMap<String, Pack> nameToPack = new HashMap<String, Pack>();
        for (Pack pack : packs) {
            nameToPack.put(pack.getName(), pack);
        }
        return nameToPack;
    }

    private Map<String, Integer> getNametoRowMapping(List<Pack> packs) {
        HashMap<String, Integer> nameToPos = new HashMap<String, Integer>();
        for (int i = 0; i < packs.size(); ++i) {
            Pack pack = packs.get(i);
            nameToPos.put(pack.getName(), i);
        }
        return nameToPos;
    }

    private List<Pack> setPackProperties(List<Pack> packs, Map<String, Pack> nameToPack) {
        for (Pack pack : packs) {
            Pack parent;
            if (pack.hasParent()) {
                String parentName = pack.getParent();
                parent = nameToPack.get(parentName);
                parent.addChild(pack.getName());
            }
            if (!pack.hasDependencies()) continue;
            for (String name : pack.getDependencies()) {
                parent = nameToPack.get(name);
                parent.addDependant(pack.getName());
            }
        }
        return packs;
    }

    public Pack getPackAtRow(int row) {
        return this.packs.get(row);
    }

    public void updateConditions() {
        this.updateConditions(false);
    }

    private void updateConditions(boolean initial) {
        boolean changes = true;
        while (changes) {
            changes = false;
            for (Pack pack : this.packs) {
                String packName = pack.getName();
                int pos = this.getPos(packName);
                logger.fine("Conditions fulfilled for: " + packName + "?");
                if (this.rules.canInstallPack(packName, this.variables)) continue;
                logger.fine("no");
                if (this.rules.canInstallPackOptional(packName, this.variables)) {
                    logger.fine("optional");
                    logger.fine(packName + " can be installed optionally.");
                    if (!initial || this.checkValues[pos] == 0) continue;
                    this.checkValues[pos] = 0;
                    changes = true;
                    continue;
                }
                if (this.checkValues[pos] == -2) continue;
                logger.fine("Pack" + packName + " cannot be installed");
                this.checkValues[pos] = -2;
                changes = true;
            }
        }
    }

    public void updateTable() {
        this.updateDeps();
        this.updateConditions();
        this.updatePacksToInstall();
        this.fireTableDataChanged();
    }

    private int[] initCheckValues(List<Pack> packs, List<Pack> packsToInstall) {
        Pack pack2;
        int i;
        int[] checkValues = new int[packs.size()];
        for (i = 0; i < packs.size(); ++i) {
            pack2 = packs.get(i);
            if (!packsToInstall.contains(pack2)) continue;
            checkValues[i] = 1;
        }
        for (i = 0; i < packs.size(); ++i) {
            pack2 = packs.get(i);
            if (checkValues[i] == 0) {
                List<String> deps = pack2.getDependants();
                for (int j = 0; deps != null && j < deps.size(); ++j) {
                    String name = deps.get(j);
                    int pos = this.getPos(name);
                    checkValues[pos] = -2;
                }
            }
            if (checkValues[i] <= 0 || pack2.getExcludeGroup() == null) continue;
            for (int q = 0; q < packs.size(); ++q) {
                if (q == i) continue;
                Pack otherPack = packs.get(q);
                if (!pack2.getExcludeGroup().equals(otherPack.getExcludeGroup()) || checkValues[q] != 1) continue;
                checkValues[q] = 0;
            }
        }
        for (Pack pack2 : packs) {
            if (!pack2.isRequired()) continue;
            checkValues = this.propRequirement(pack2.getName(), checkValues);
        }
        return checkValues;
    }

    private int[] propRequirement(String name, int[] checkValues) {
        int pos = this.getPos(name);
        checkValues[pos] = -1;
        List<String> deps = this.packs.get(pos).getDependencies();
        int i = 0;
        if (deps != null && i < deps.size()) {
            String s = deps.get(i);
            return this.propRequirement(s, checkValues);
        }
        return checkValues;
    }

    private int getPos(String name) {
        return this.nameToRow.get(name);
    }

    @Override
    public int getRowCount() {
        return this.packs.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.checkValues[rowIndex] < 0) {
            return false;
        }
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Pack pack = this.packs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return this.checkValues[rowIndex];
            }
            case 1: {
                return PackHelper.getPackName(pack, this.messages);
            }
            case 2: {
                return Pack.toByteUnitsString(pack.getSize());
            }
        }
        return null;
    }

    public void toggleValueAt(int rowIndex) {
        if (this.checkValues[rowIndex] == 1) {
            this.setValueAt(0, rowIndex, 0);
        } else {
            this.setValueAt(1, rowIndex, 0);
        }
    }

    @Override
    public void setValueAt(Object checkValue, int rowIndex, int columnIndex) {
        boolean added;
        if (columnIndex != 0 || !(checkValue instanceof Integer)) {
            return;
        }
        Pack pack = this.packs.get(rowIndex);
        if ((Integer)checkValue == 1) {
            added = true;
            String name = pack.getName();
            if (this.rules.canInstallPack(name, this.variables) || this.rules.canInstallPackOptional(name, this.variables)) {
                this.checkValues[rowIndex] = pack.isRequired() ? -1 : 1;
            }
        } else {
            added = false;
            this.checkValues[rowIndex] = 0;
        }
        this.updateExcludes(rowIndex);
        this.updateDeps();
        if (added) {
            this.onSelectionUpdate(rowIndex);
            this.packsToInstall.add(pack);
            this.updateConditions();
            this.packsToInstall.remove(pack);
        } else {
            this.onDeselectionUpdate(rowIndex);
            this.packsToInstall.remove(pack);
            this.updateConditions();
            this.packsToInstall.add(pack);
        }
        this.updatePacksToInstall();
        if (pack.hasParent()) {
            this.updateParent(pack);
        } else if (pack.hasChildren()) {
            this.updateChildren(pack);
        }
        this.fireTableDataChanged();
    }

    private void updateParent(Pack childPack) {
        String parentName = childPack.getParent();
        Pack parentPack = this.nameToPack.get(parentName);
        int parentPosition = this.nameToRow.get(parentName);
        int childrenSelected = 0;
        for (String childName : parentPack.getChildren()) {
            int childPosition = this.nameToRow.get(childName);
            if (!this.isChecked(childPosition)) continue;
            ++childrenSelected;
        }
        this.checkValues[parentPosition] = parentPack.getChildren().size() == childrenSelected ? (this.checkValues[parentPosition] < 0 ? -1 : 1) : (childrenSelected > 0 ? (this.checkValues[parentPosition] < 0 ? -3 : 2) : (this.checkValues[parentPosition] < 0 ? -4 : 0));
    }

    private void updateChildren(Pack parentPack) {
        String parentName = parentPack.getName();
        int parentPosition = this.nameToRow.get(parentName);
        int parentValue = this.checkValues[parentPosition];
        for (String childName : parentPack.getChildren()) {
            int childPosition = this.nameToRow.get(childName);
            this.checkValues[childPosition] = parentValue;
        }
    }

    private void selectionUpdate(Map<String, String> packsData) {
        RulesEngine rules = this.installData.getRules();
        for (Map.Entry<String, String> packData : packsData.entrySet()) {
            int value;
            int packPos;
            Pack pack;
            String packName = packData.getKey();
            String condition = packData.getValue();
            if (condition != null && !rules.isConditionTrue(condition)) {
                return;
            }
            if (packName.startsWith("!")) {
                packName = packName.substring(1);
                pack = this.nameToPack.get(packName);
                packPos = this.getPos(packName);
                value = 0;
            } else {
                pack = this.nameToPack.get(packName);
                packPos = this.getPos(packName);
                value = 1;
            }
            if (pack.isRequired() || !this.dependenciesResolved(pack)) continue;
            this.checkValues[packPos] = value;
        }
    }

    protected void onSelectionUpdate(int index) {
        Pack pack = this.packs.get(index);
        Map<String, String> packsData = pack.getOnSelect();
        this.selectionUpdate(packsData);
    }

    protected void onDeselectionUpdate(int index) {
        Pack pack = this.packs.get(index);
        Map<String, String> packsData = pack.getOnDeselect();
        this.selectionUpdate(packsData);
    }

    public List<Pack> updatePacksToInstall() {
        this.packsToInstall.clear();
        for (int i = 0; i < this.packs.size(); ++i) {
            Pack pack = this.packs.get(i);
            if (this.isChecked(i) && !this.installedPacks.containsKey(pack.getName())) {
                this.packsToInstall.add(pack);
                continue;
            }
            if (!this.installedPacks.containsKey(pack.getName())) continue;
            this.checkValues[i] = -3;
        }
        for (Pack hiddenPack : this.hiddenPacks) {
            if (!this.rules.canInstallPack(hiddenPack.getName(), this.variables)) continue;
            this.packsToInstall.add(hiddenPack);
        }
        this.installData.setSelectedPacks(this.packsToInstall);
        return this.packsToInstall;
    }

    protected void updateDeps() {
        int i;
        int[] statusArray = new int[this.packs.size()];
        for (i = 0; i < statusArray.length; ++i) {
            statusArray[i] = 0;
        }
        this.dfs(statusArray);
        for (i = 0; i < statusArray.length; ++i) {
            if (statusArray[i] == 0 && this.checkValues[i] < 0) {
                int n = i;
                this.checkValues[n] = this.checkValues[n] + 2;
            }
            if (statusArray[i] != 1 || this.checkValues[i] < 0) continue;
            this.checkValues[i] = -2;
        }
        for (Pack pack : this.packs) {
            String name;
            if (!pack.isRequired() || !this.rules.canInstallPack(name = pack.getName(), this.variables) && this.rules.canInstallPackOptional(name, this.variables)) continue;
            this.checkValues = this.propRequirement(name, this.checkValues);
        }
    }

    protected void updateExcludes(int rowindex) {
        int value = this.checkValues[rowindex];
        Pack pack = this.packs.get(rowindex);
        if (value > 0 && pack.getExcludeGroup() != null) {
            for (int q = 0; q < this.packs.size(); ++q) {
                if (rowindex == q) continue;
                Pack otherPack = this.packs.get(q);
                String name1 = otherPack.getExcludeGroup();
                String name2 = pack.getExcludeGroup();
                if (!name2.equals(name1) || this.checkValues[q] != 1) continue;
                this.checkValues[q] = 0;
            }
        }
    }

    private int dfs(int[] status) {
        HashMap<String, PackColor> colours = new HashMap<String, PackColor>();
        for (int i = 0; i < this.packs.size(); ++i) {
            boolean wipe;
            for (Pack pack : this.packs) {
                colours.put(pack.getName(), PackColor.WHITE);
            }
            Pack pack = this.packs.get(i);
            if (this.dfsVisit(pack, status, wipe = false, colours) == 0) continue;
            return -1;
        }
        return 0;
    }

    private int dfsVisit(Pack u, int[] status, boolean wipe, Map<String, PackColor> colours) {
        List<String> deps;
        colours.put(u.getName(), PackColor.GREY);
        int check = this.checkValues[this.getPos(u.getName())];
        if (Math.abs(check) != 1) {
            wipe = true;
        }
        if ((deps = u.getDependants()) != null) {
            for (String name : deps) {
                int result;
                Pack v = this.nameToPack.get(name);
                if (wipe) {
                    status[this.getPos((String)v.getName())] = 1;
                }
                if (colours.get(v.getName()) != PackColor.WHITE || (result = this.dfsVisit(v, status, wipe, colours)) == 0) continue;
                return result;
            }
        }
        colours.put(u.getName(), PackColor.BLACK);
        return 0;
    }

    public Map<String, Pack> getInstalledPacks() {
        return this.installedPacks;
    }

    public boolean isModifyInstallation() {
        return this.modifyInstallation;
    }

    private void removeAlreadyInstalledPacks(List<Pack> selectedPacks) {
        ArrayList<Pack> removePacks = new ArrayList<Pack>();
        for (Pack selectedPack : selectedPacks) {
            if (!this.installedPacks.containsKey(selectedPack.getName())) continue;
            removePacks.add(selectedPack);
        }
        for (Pack removePack : removePacks) {
            selectedPacks.remove(removePack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Pack> loadInstallationInformation(boolean modifyInstallation) {
        HashMap<String, Pack> installedpacks = new HashMap<String, Pack>();
        if (!modifyInstallation) {
            return installedpacks;
        }
        ObjectInputStream oin = null;
        try {
            FileInputStream fin = new FileInputStream(new File(this.installData.getInstallPath() + File.separator + ".installationinformation"));
            oin = new ObjectInputStream(fin);
            List packsinstalled = (List)oin.readObject();
            for (Pack installedpack : packsinstalled) {
                installedpacks.put(installedpack.getName(), installedpack);
            }
            this.removeAlreadyInstalledPacks(this.installData.getSelectedPacks());
            logger.fine("Found " + packsinstalled.size() + " installed packs");
            Properties variables = (Properties)oin.readObject();
            for (Object key : variables.keySet()) {
                this.installData.setVariable((String)key, (String)variables.get(key));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (IOException e) {}
            }
        }
        return installedpacks;
    }

    private boolean dependenciesResolved(Pack pack) {
        if (!pack.hasDependencies()) {
            return true;
        }
        for (String dependentPackName : pack.getDependencies()) {
            if (this.isChecked(this.nameToRow.get(dependentPackName))) continue;
            return false;
        }
        return true;
    }

    public Map<String, Pack> getNameToPack() {
        return this.nameToPack;
    }

    public Map<Pack, Integer> getPacksToRowNumbers() {
        HashMap<Pack, Integer> packsToRowNumbers = new HashMap<Pack, Integer>();
        for (Map.Entry<String, Integer> entry : this.nameToRow.entrySet()) {
            packsToRowNumbers.put(this.nameToPack.get(entry.getKey()), entry.getValue());
        }
        return packsToRowNumbers;
    }

    public Map<String, Integer> getNameToRow() {
        return this.nameToRow;
    }

    public int getTotalByteSize() {
        Map<Pack, Integer> packToRow = this.getPacksToRowNumbers();
        int bytes = 0;
        for (Pack pack : this.packs) {
            int row = packToRow.get(pack);
            if (!this.isChecked(row)) continue;
            bytes = (int)((long)bytes + pack.getSize());
        }
        return bytes;
    }

    public boolean isChecked(int row) {
        return this.checkValues[row] == 1 || this.checkValues[row] == -1 || this.checkValues[row] == 2 || this.checkValues[row] == -3;
    }

    public boolean isPartiallyChecked(int row) {
        return this.checkValues[row] == 2 || this.checkValues[row] == -3;
    }

    public boolean isCheckBoxSelectable(int row) {
        return this.checkValues[row] >= 0;
    }

    public boolean dependenciesExist() {
        for (Pack pack : this.getVisiblePacks()) {
            if (!pack.hasDependencies()) continue;
            return true;
        }
        return false;
    }

    public Pack getPack(String packName) {
        return this.nameToPack.get(packName);
    }
}

