/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.cos.PBCosRenderingIntent;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXObject;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.model.pdlayer.PDXImage;

public class PBoxPDXImage
extends PBoxPDXObject
implements PDXImage {
    public static final Logger logger = Logger.getLogger(PBoxPDXImage.class);
    public static final String IMAGE_CS = "imageCS";
    public static final String ALTERNATES = "Alternates";
    public static final String INTENT = "Intent";

    public PBoxPDXImage(PDImageXObject simplePDObject) {
        super((PDXObject)simplePDObject);
        this.setType("PDXImage");
    }

    public Boolean getInterpolate() {
        return ((PDImageXObject)this.simplePDObject).getInterpolate();
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        List<CosRenderingIntent> list;
        switch (link) {
            case "Intent": {
                list = this.getIntent();
                break;
            }
            case "imageCS": {
                list = this.getImageCS();
                break;
            }
            case "Alternates": {
                list = this.getAlternates();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<CosRenderingIntent> getIntent() {
        ArrayList<CosRenderingIntent> intents = new ArrayList<CosRenderingIntent>(MAX_NUMBER_OF_ELEMENTS);
        COSStream imageStream = ((PDImageXObject)this.simplePDObject).getCOSStream();
        COSName intent = imageStream.getCOSName(COSName.getPDFName((String)INTENT));
        if (intent != null) {
            intents.add(new PBCosRenderingIntent(intent));
        }
        return intents;
    }

    private List<PDColorSpace> getImageCS() {
        ArrayList<PDColorSpace> colorSpaces = new ArrayList<PDColorSpace>(1);
        try {
            PDColorSpace buffer = ColorSpaceFactory.getColorSpace(((PDImageXObject)this.simplePDObject).getColorSpace());
            if (buffer != null) {
                colorSpaces.add(buffer);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Problems with color space obtaining from Image XObject. " + e.getMessage()));
        }
        return colorSpaces;
    }

    private List<PDXImage> getAlternates() {
        ArrayList<PDXImage> alternates = new ArrayList<PDXImage>();
        COSStream imageStream = ((PDImageXObject)this.simplePDObject).getCOSStream();
        COSBase buffer = imageStream.getItem(COSName.getPDFName((String)ALTERNATES));
        this.addAlternates(alternates, buffer);
        return alternates;
    }

    private void addAlternates(List<PDXImage> alternates, COSBase buffer) {
        if (buffer instanceof COSArray) {
            for (COSBase element : (COSArray)buffer) {
                this.addAlternate(alternates, element);
            }
        } else if (buffer instanceof COSObject) {
            this.addAlternates(alternates, ((COSObject)buffer).getObject());
        }
    }

    private void addAlternate(List<PDXImage> alternates, COSBase buffer) {
        COSDictionary alternate = this.getDictionary(buffer);
        if (alternate != null) {
            COSStream alternatesImages = (COSStream)alternate.getDictionaryObject(COSName.IMAGE);
            try {
                if (alternatesImages != null) {
                    PDStream stream = new PDStream(alternatesImages);
                    PDResources res = ((PDImageXObject)this.simplePDObject).getResources();
                    PDImageXObject imageXObject = new PDImageXObject(stream, res);
                    alternates.add(new PBoxPDXImage(imageXObject));
                }
            }
            catch (IOException e) {
                logger.error((Object)("Error in creating Alternate XObject. " + e.getMessage()));
            }
        }
    }
}

