/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.impl.pb.cos.PBCosStream;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.PBoxPDGroup;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXObject;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.pdlayer.PDGroup;
import org.verapdf.model.pdlayer.PDXForm;

public class PBoxPDXForm
extends PBoxPDXObject
implements PDXForm {
    public static final Logger logger = Logger.getLogger(PBoxPDXForm.class);
    public static final String GROUP = "Group";
    public static final String PS = "PS";
    public static final String REF = "Ref";
    public static final String CONTENT_STREAM = "contentStream";

    public PBoxPDXForm(PDFormXObject simplePDObject) {
        super((PDXObject)simplePDObject);
        this.setType("PDXForm");
    }

    public String getSubtype2() {
        COSStream subtype2 = ((PDFormXObject)this.simplePDObject).getCOSStream();
        return this.getSubtypeString(subtype2.getItem(COSName.getPDFName((String)"Subtype2")));
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        List<PDGroup> list;
        switch (link) {
            case "Group": {
                list = this.getGroup();
                break;
            }
            case "PS": {
                list = this.getPS();
                break;
            }
            case "Ref": {
                list = this.getREF();
                break;
            }
            case "contentStream": {
                list = this.getContentStream();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<PDGroup> getGroup() {
        ArrayList<PDGroup> groups = new ArrayList<PDGroup>(1);
        org.apache.pdfbox.pdmodel.graphics.form.PDGroup group = ((PDFormXObject)this.simplePDObject).getGroup();
        if (group != null) {
            groups.add(new PBoxPDGroup(group));
        }
        return groups;
    }

    private List<CosStream> getPS() {
        ArrayList<CosStream> postScript = new ArrayList<CosStream>(1);
        COSStream cosStream = ((PDFormXObject)this.simplePDObject).getCOSStream();
        COSStream ps = (COSStream)cosStream.getDictionaryObject(COSName.PS);
        if (ps != null) {
            postScript.add(new PBCosStream(ps));
        }
        return postScript;
    }

    private List<CosDict> getREF() {
        return this.getLinkToDictionary(REF);
    }

    private List<PDContentStream> getContentStream() {
        ArrayList<PDContentStream> contentStreams = new ArrayList<PDContentStream>(1);
        contentStreams.add(new PBoxPDContentStream((org.apache.pdfbox.contentstream.PDContentStream)((PDFormXObject)this.simplePDObject)));
        return contentStreams;
    }
}

