/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.verapdf.model.impl.pb.pd.PBoxPDAnnot;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.PBoxPDGroup;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.pdlayer.PDGroup;
import org.verapdf.model.pdlayer.PDPage;

public class PBoxPDPage
extends PBoxPDObject
implements PDPage {
    public static final Logger logger = Logger.getLogger(PBoxPDPage.class);
    public static final String ANNOTS = "annots";
    public static final String ACTION = "action";
    public static final String CONTENT_STREAM = "contentStream";
    public static final String GROUP = "Group";
    public static final Integer MAX_NUMBER_OF_ACTIONS = 2;

    public PBoxPDPage(org.apache.pdfbox.pdmodel.PDPage simplePDObject) {
        super((COSObjectable)simplePDObject);
        this.setType("PDPage");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "Group": {
                list = this.getGroup();
                break;
            }
            case "annots": {
                list = this.getAnnotations();
                break;
            }
            case "action": {
                list = this.getActions();
                break;
            }
            case "contentStream": {
                list = this.getContentStream();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<PDGroup> getGroup() {
        ArrayList<PDGroup> groups = new ArrayList<PDGroup>(1);
        COSDictionary dictionary = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getCOSObject();
        COSBase groupDictionary = dictionary.getDictionaryObject(COSName.GROUP);
        if (groupDictionary instanceof COSDictionary) {
            org.apache.pdfbox.pdmodel.graphics.form.PDGroup group = new org.apache.pdfbox.pdmodel.graphics.form.PDGroup((COSDictionary)groupDictionary);
            groups.add(new PBoxPDGroup(group));
        }
        return groups;
    }

    private List<PDContentStream> getContentStream() {
        ArrayList<PDContentStream> contentStreams = new ArrayList<PDContentStream>();
        contentStreams.add(new PBoxPDContentStream((org.apache.pdfbox.contentstream.PDContentStream)((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject)));
        return contentStreams;
    }

    private List<org.verapdf.model.pdlayer.PDAction> getActions() {
        ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(MAX_NUMBER_OF_ACTIONS);
        PDPageAdditionalActions pbActions = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getActions();
        if (pbActions != null) {
            PDAction action = pbActions.getC();
            this.addAction(actions, action);
            action = pbActions.getO();
            this.addAction(actions, action);
        }
        return actions;
    }

    private List<PDAnnot> getAnnotations() {
        ArrayList<PDAnnot> annotations = new ArrayList<PDAnnot>();
        try {
            List pdfboxAnnotations = ((org.apache.pdfbox.pdmodel.PDPage)this.simplePDObject).getAnnotations();
            if (pdfboxAnnotations != null) {
                for (PDAnnotation annotation : pdfboxAnnotations) {
                    if (annotation == null) continue;
                    annotations.add(new PBoxPDAnnot(annotation));
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)("Problems in obtaining pdfbox PDAnnotations. " + e.getMessage()));
        }
        return annotations;
    }
}

