/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDGroup;

public class PBoxPDGroup
extends PBoxPDObject
implements PDGroup {
    public static final Logger logger = Logger.getLogger(PBoxPDGroup.class);
    public static final String COLOR_SPACE = "colorSpace";
    private final Integer MAX_COLOR_SPACES = 1;

    public PBoxPDGroup(org.apache.pdfbox.pdmodel.graphics.form.PDGroup simplePDObject) {
        super((COSObjectable)simplePDObject);
        this.setType("PDGroup");
    }

    public String getS() {
        return ((org.apache.pdfbox.pdmodel.graphics.form.PDGroup)this.simplePDObject).getSubType().getName();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "colorSpace": {
                list = this.getColorSpace();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getColorSpace() {
        ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpaces = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(this.MAX_COLOR_SPACES);
        try {
            PDColorSpace pbColorSpace = ((org.apache.pdfbox.pdmodel.graphics.form.PDGroup)this.simplePDObject).getColorSpace();
            org.verapdf.model.pdlayer.PDColorSpace colorSpace = ColorSpaceFactory.getColorSpace(pbColorSpace);
            if (colorSpace != null) {
                colorSpaces.add(colorSpace);
            }
        }
        catch (IOException e) {
            logger.error((java.lang.Object)("Problems with color space obtaining on group. " + e.getMessage()));
        }
        return colorSpaces;
    }
}

