/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.impl.pb.cos.PBCosReal;
import org.verapdf.model.impl.pb.pd.PBoxPDAction;
import org.verapdf.model.impl.pb.pd.PBoxPDContentStream;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDAnnot;
import org.verapdf.model.pdlayer.PDContentStream;

public class PBoxPDAnnot
extends PBoxPDObject
implements PDAnnot {
    public static final String APPEARANCE = "appearance";
    public static final String C = "C";
    public static final String IC = "IC";
    public static final String A = "A";
    public static final String ADDITIONAL_ACTION = "AA";
    public static final Integer MAXIMAL_COUNT_OF_ELEMENTS = 1;
    public static final Integer MAX_COUNT_OF_ACTIONS = 10;

    public PBoxPDAnnot(PDAnnotation simplePDObject) {
        super((COSObjectable)simplePDObject);
        this.setType("PDAnnot");
    }

    public String getSubtype() {
        return ((PDAnnotation)this.simplePDObject).getSubtype();
    }

    public String getAP() {
        COSBase ap = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.AP);
        return ap != null ? ap.toString() : null;
    }

    public Long getF() {
        return ((PDAnnotation)this.simplePDObject).getAnnotationFlags();
    }

    public Double getCA() {
        COSBase ca = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.CA);
        return ca instanceof COSNumber ? Double.valueOf(((COSNumber)ca).doubleValue()) : null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "AA": {
                list = this.getAdditionalActions();
                break;
            }
            case "A": {
                list = this.getA();
                break;
            }
            case "IC": {
                list = this.getIC();
                break;
            }
            case "C": {
                list = this.getC();
                break;
            }
            case "appearance": {
                list = this.getAppearance();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<org.verapdf.model.pdlayer.PDAction> getAdditionalActions() {
        ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(MAX_COUNT_OF_ACTIONS);
        COSBase actionDictionary = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.AA);
        if (actionDictionary instanceof COSDictionary) {
            PDAnnotationAdditionalActions additionalActions = new PDAnnotationAdditionalActions((COSDictionary)actionDictionary);
            PDAction buffer = additionalActions.getBl();
            this.addAction(actions, buffer);
            buffer = additionalActions.getD();
            this.addAction(actions, buffer);
            buffer = additionalActions.getE();
            this.addAction(actions, buffer);
            buffer = additionalActions.getFo();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPC();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPI();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPO();
            this.addAction(actions, buffer);
            buffer = additionalActions.getPV();
            this.addAction(actions, buffer);
            buffer = additionalActions.getU();
            this.addAction(actions, buffer);
            buffer = additionalActions.getX();
            this.addAction(actions, buffer);
        }
        return actions;
    }

    private List<org.verapdf.model.pdlayer.PDAction> getA() {
        PDAction action;
        ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(MAXIMAL_COUNT_OF_ELEMENTS);
        COSBase actionDictionary = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(COSName.A);
        if (actionDictionary instanceof COSDictionary && (action = PDActionFactory.createAction((COSDictionary)((COSDictionary)actionDictionary))) != null) {
            actions.add(new PBoxPDAction(action));
        }
        return actions;
    }

    private List<CosReal> getIC() {
        return this.getRealsFromArray(COSName.IC);
    }

    private List<CosReal> getC() {
        return this.getRealsFromArray(COSName.C);
    }

    private List<CosReal> getRealsFromArray(COSName arrayName) {
        ArrayList<CosReal> color = new ArrayList<CosReal>();
        COSBase colorArray = ((PDAnnotation)this.simplePDObject).getCOSObject().getDictionaryObject(arrayName);
        if (colorArray instanceof COSArray) {
            for (COSBase colorValue : (COSArray)colorArray) {
                if (!(colorValue instanceof COSNumber)) continue;
                color.add(new PBCosReal((COSNumber)colorValue));
            }
        }
        return color;
    }

    private List<PDContentStream> getAppearance() {
        PDAppearanceEntry normalAppearance;
        ArrayList<PDContentStream> appearances = new ArrayList<PDContentStream>(MAXIMAL_COUNT_OF_ELEMENTS);
        PDAppearanceDictionary appearanceDictionary = ((PDAnnotation)this.simplePDObject).getAppearance();
        if (appearanceDictionary != null && (normalAppearance = appearanceDictionary.getNormalAppearance()) != null && normalAppearance.isStream()) {
            appearances.add(new PBoxPDContentStream((org.apache.pdfbox.contentstream.PDContentStream)normalAppearance.getAppearanceStream()));
        }
        return appearances;
    }
}

