/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosDocument;
import org.verapdf.model.impl.pb.cos.PBCosDocument;

public final class ModelLoader {
    private static final Logger logger = Logger.getLogger(ModelLoader.class);
    private File file;
    private PDDocument document;

    public ModelLoader(String path) {
        this.file = new File(path);
    }

    public PDDocument getPDDocument() throws IOException {
        if (this.document == null) {
            if (!this.file.exists() || !this.file.isFile()) {
                logger.error((java.lang.Object)("Invalid path to document '" + this.file.getPath() + "'. File does not exist or not a file."));
            } else {
                this.document = PDDocument.load((File)this.file, (boolean)Boolean.FALSE, (boolean)Boolean.TRUE);
            }
        }
        return this.document;
    }

    public CosDocument getRoot() throws IOException {
        if (this.document == null) {
            this.document = this.getPDDocument();
        }
        if (this.document == null) {
            return null;
        }
        return new PBCosDocument(this.document, this.file.length());
    }

    public static Object getRoot(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException("Current file '" + path + "' not exists.");
        }
        PDDocument document = PDDocument.load((File)file, (boolean)Boolean.FALSE, (boolean)Boolean.TRUE);
        PBCosDocument root = new PBCosDocument(document, file.length());
        return root;
    }
}

