/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLFeaturesReport {
    private XMLFeaturesReport() {
    }

    public static Element makeXMLTree(FeaturesCollection collection, Document doc) {
        Element pdfFeatures = doc.createElement("pdfFeatures");
        if (collection != null) {
            XMLFeaturesReport.parseElements(FeaturesObjectTypesEnum.INFORMATION_DICTIONARY, collection, pdfFeatures, doc);
            if (collection.getFeatureTreesForType(FeaturesObjectTypesEnum.METADATA) != null) {
                for (FeatureTreeNode metadataNode : collection.getFeatureTreesForType(FeaturesObjectTypesEnum.METADATA)) {
                    if (metadataNode == null) continue;
                    pdfFeatures.appendChild(XMLFeaturesReport.parseMetadata(metadataNode, collection, doc));
                }
            }
            XMLFeaturesReport.parseElements(FeaturesObjectTypesEnum.LOW_LEVEL_INFO, collection, pdfFeatures, doc);
            if (collection.getFeatureTreesForType(FeaturesObjectTypesEnum.OUTPUTINTENT) != null) {
                pdfFeatures.appendChild(XMLFeaturesReport.makeList("outputIntents", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.OUTPUTINTENT), doc));
            }
            XMLFeaturesReport.parseElements(FeaturesObjectTypesEnum.OUTLINES, collection, pdfFeatures, doc);
            if (collection.getFeatureTreesForType(FeaturesObjectTypesEnum.PAGE) != null) {
                pdfFeatures.appendChild(XMLFeaturesReport.makeList("pages", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.PAGE), doc));
            }
            if (collection.getFeatureTreesForType(FeaturesObjectTypesEnum.ERROR) != null) {
                pdfFeatures.appendChild(XMLFeaturesReport.makeList("errors", collection.getFeatureTreesForType(FeaturesObjectTypesEnum.ERROR), doc));
            }
        }
        return pdfFeatures;
    }

    private static void parseElements(FeaturesObjectTypesEnum type, FeaturesCollection collection, Element root, Document doc) {
        if (collection.getFeatureTreesForType(type) != null) {
            for (FeatureTreeNode rootNode : collection.getFeatureTreesForType(type)) {
                if (rootNode == null) continue;
                root.appendChild(XMLFeaturesReport.makeNode(rootNode, doc));
            }
        }
    }

    private static Element parseMetadata(FeatureTreeNode metadataNode, FeaturesCollection collection, Document doc) {
        if (metadataNode.getAttributes() == null || metadataNode.getAttributes().get("errorId") == null) {
            Element metadata = doc.createElement("metadata");
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document metadataDocument = builder.parse(new InputSource(new StringReader(metadataNode.getValue())));
                Node pack = doc.importNode(metadataDocument.getDocumentElement(), true);
                pack.normalize();
                metadata.appendChild(pack);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                metadata.appendChild(doc.createTextNode(XMLFeaturesReport.removeZeros(metadataNode.getValue())));
                metadata.setAttribute("errorId", "metaerr2");
                ErrorsHelper.addErrorIntoCollection((FeaturesCollection)collection, (String)"metaerr2", (String)"Error while parsing metadata into DOM.");
            }
            return metadata;
        }
        return XMLFeaturesReport.makeNode(metadataNode, doc);
    }

    private static Element makeList(String listName, List<FeatureTreeNode> list, Document doc) {
        Element listElement = doc.createElement(listName);
        if (list != null) {
            for (FeatureTreeNode node : list) {
                if (node == null) continue;
                listElement.appendChild(XMLFeaturesReport.makeNode(node, doc));
            }
        }
        return listElement;
    }

    private static Element makeNode(FeatureTreeNode node, Document doc) {
        Element root = doc.createElement(node.getName());
        for (Map.Entry attr : node.getAttributes().entrySet()) {
            root.setAttribute((String)attr.getKey(), XMLFeaturesReport.removeZeros((String)attr.getValue()));
        }
        if (node.isLeaf() && node.getValue() != null) {
            root.appendChild(doc.createTextNode(XMLFeaturesReport.removeZeros(node.getValue())));
        } else if (node.getChildren() != null) {
            for (FeatureTreeNode child : node.getChildren()) {
                root.appendChild(XMLFeaturesReport.makeNode(child, doc));
            }
        }
        return root;
    }

    private static String removeZeros(String str) {
        return str.replaceAll(String.valueOf('\u0000'), "");
    }
}

