/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import org.verapdf.gui.AboutPanel;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.gui.MiniLogoPanel;

public class PDFValidationApplication
extends JFrame {
    private static Logger logger = Logger.getLogger(PDFValidationApplication.class.getName());
    private AboutPanel aboutPanel;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    logger.log(Level.SEVERE, "Exception in configuring UI manager: ", e);
                }
                try {
                    PDFValidationApplication frame = new PDFValidationApplication();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Exception: ", e);
                }
            }
        });
    }

    public PDFValidationApplication() {
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 550, 350);
        this.setResizable(false);
        this.setTitle("PDF/A Conformance Checker");
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        this.aboutPanel = null;
        try {
            this.aboutPanel = new AboutPanel();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in reading logo image.", "Error", 0);
            logger.log(Level.SEVERE, "Exception in reading logo image: ", e);
        }
        JMenuItem about = new JMenuItem("About");
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFValidationApplication.this.aboutPanel != null) {
                    PDFValidationApplication.this.aboutPanel.showDialog(PDFValidationApplication.this, "About veraPDF");
                }
            }
        });
        menuBar.add(about);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.setContentPane(contentPane);
        MiniLogoPanel logoPanel = null;
        try {
            logoPanel = new MiniLogoPanel("veraPDF-logo-600.png");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in creating mini logo.", "Error", 0);
            logger.log(Level.SEVERE, "Exception in creating mini logo: ", e);
        }
        contentPane.add(logoPanel);
        CheckerPanel checkerPanel = null;
        try {
            checkerPanel = new CheckerPanel();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error in loading xml or html image.", "Error", 0);
            logger.log(Level.SEVERE, "Exception in loading xml or html image: ", e);
        }
        contentPane.add(checkerPanel);
    }
}

