/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.profile.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.verapdf.exceptions.validationprofileparser.IncorrectImportPathException;
import org.verapdf.exceptions.validationprofileparser.MissedHashTagException;
import org.verapdf.exceptions.validationprofileparser.NullProfileException;
import org.verapdf.exceptions.validationprofileparser.WrongProfileEncodingException;
import org.verapdf.exceptions.validationprofileparser.WrongSignatureException;
import org.verapdf.validation.profile.model.Fix;
import org.verapdf.validation.profile.model.FixError;
import org.verapdf.validation.profile.model.FixInfo;
import org.verapdf.validation.profile.model.Reference;
import org.verapdf.validation.profile.model.Rule;
import org.verapdf.validation.profile.model.RuleError;
import org.verapdf.validation.profile.model.ValidationProfile;
import org.verapdf.validation.profile.model.Variable;
import org.verapdf.validation.profile.parser.ValidationProfileSignatureChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ValidationProfileParser {
    private Set<String> profilesPaths;
    private ValidationProfile profile;
    private DocumentBuilder builder;
    private File resource;

    private ValidationProfileParser(File resourceFile, boolean isSignCheckOn) throws ParserConfigurationException, IOException, SAXException, IncorrectImportPathException, XMLStreamException, MissedHashTagException, WrongSignatureException, WrongProfileEncodingException, NullProfileException {
        ValidationProfileSignatureChecker checker;
        this.resource = resourceFile;
        if (isSignCheckOn && !(checker = ValidationProfileSignatureChecker.newInstance(this.resource)).isValidSignature()) {
            throw new WrongSignatureException("Unsigned validation profile: " + this.resource.getCanonicalPath());
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.builder = factory.newDocumentBuilder();
        factory.setIgnoringElementContentWhitespace(true);
        Document doc = this.builder.parse(this.resource);
        this.profilesPaths = new HashSet<String>();
        this.profilesPaths.add(resourceFile.getCanonicalPath());
        Element root = doc.getDocumentElement();
        root.normalize();
        this.parseRoot(root, isSignCheckOn);
    }

    private void parseRoot(Node root, boolean isSignCheckOn) throws IOException, SAXException, IncorrectImportPathException {
        String model = null;
        String name = null;
        String description = null;
        String creator = null;
        String created = null;
        String hash = null;
        HashMap<String, List<Rule>> rules = new HashMap<String, List<Rule>>();
        HashMap<String, List<Variable>> variables = new HashMap<String, List<Variable>>();
        Node modelNode = root.getAttributes().getNamedItem("model");
        if (modelNode != null) {
            model = modelNode.getNodeValue();
        }
        NodeList children = root.getChildNodes();
        block20: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "name": {
                    name = child.getTextContent().trim();
                    continue block20;
                }
                case "description": {
                    description = child.getTextContent().trim();
                    continue block20;
                }
                case "creator": {
                    creator = child.getTextContent().trim();
                    continue block20;
                }
                case "created": {
                    created = child.getTextContent().trim();
                    continue block20;
                }
                case "hash": {
                    if (!isSignCheckOn) continue block20;
                    hash = child.getTextContent().trim();
                    continue block20;
                }
                case "imports": {
                    this.parseImports(this.resource, child, rules);
                    continue block20;
                }
                case "rules": {
                    this.parseRules(child, rules);
                    continue block20;
                }
                case "variables": {
                    this.parseVariables(child, variables);
                    continue block20;
                }
            }
        }
        this.profile = new ValidationProfile(model, name, description, creator, created, hash, rules, variables);
    }

    private void parseImports(File sourceFile, Node imports, Map<String, List<Rule>> rules) throws SAXException, IncorrectImportPathException, IOException {
        NodeList children = imports.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("import")) continue;
            String path = child.getTextContent().trim();
            File newFile = new File(sourceFile.getParent(), path);
            if (!newFile.exists()) {
                throw new IncorrectImportPathException("Can not find import with path \"" + path + "\" directly to the given profile.");
            }
            if (this.profilesPaths.contains(newFile.getCanonicalPath())) continue;
            this.profilesPaths.add(newFile.getCanonicalPath());
            Document doc = this.builder.parse(newFile);
            NodeList children2 = doc.getDocumentElement().getChildNodes();
            block9: for (int j = 0; j < children2.getLength(); ++j) {
                String name;
                Node child2 = children2.item(j);
                switch (name = child2.getNodeName()) {
                    case "rules": {
                        this.parseRules(child2, rules);
                        continue block9;
                    }
                    case "imports": {
                        this.parseImports(newFile, child2, rules);
                        continue block9;
                    }
                }
            }
        }
    }

    private void parseRules(Node rules, Map<String, List<Rule>> rulesMap) {
        NodeList children = rules.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("rule")) continue;
            Rule rule = this.parseRule(child);
            if (rulesMap.get(rule.getAttrObject()) == null) {
                ArrayList newRules = new ArrayList();
                rulesMap.put(rule.getAttrObject(), newRules);
            }
            rulesMap.get(rule.getAttrObject()).add(rule);
        }
    }

    private Rule parseRule(Node rule) {
        Node objectNode;
        String id = null;
        String object = null;
        String description = null;
        String test = null;
        RuleError ruleError = null;
        boolean isHasError = false;
        Reference reference = null;
        ArrayList<Fix> fix = new ArrayList<Fix>();
        Node idNode = rule.getAttributes().getNamedItem("id");
        if (idNode != null) {
            id = idNode.getNodeValue();
        }
        if ((objectNode = rule.getAttributes().getNamedItem("object")) != null) {
            object = objectNode.getNodeValue();
        }
        NodeList children = rule.getChildNodes();
        block16: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "description": {
                    description = child.getTextContent().trim();
                    continue block16;
                }
                case "test": {
                    test = child.getTextContent().trim();
                    continue block16;
                }
                case "error": {
                    ruleError = this.parseRuleError(child);
                    isHasError = true;
                    continue block16;
                }
                case "warning": {
                    ruleError = this.parseRuleError(child);
                    continue block16;
                }
                case "reference": {
                    reference = this.parseReference(child);
                    continue block16;
                }
                case "fix": {
                    fix.add(this.parseFix(child));
                    continue block16;
                }
            }
        }
        return new Rule(id, object, description, ruleError, isHasError, test, reference, fix);
    }

    private void parseVariables(Node rules, Map<String, List<Variable>> variablesMap) {
        NodeList children = rules.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("variable")) continue;
            Variable variable = this.parseVariable(child);
            if (variablesMap.get(variable.getAttrObject()) == null) {
                ArrayList newVariables = new ArrayList();
                variablesMap.put(variable.getAttrObject(), newVariables);
            }
            variablesMap.get(variable.getAttrObject()).add(variable);
        }
    }

    private Variable parseVariable(Node rule) {
        Node objectNode;
        String name = null;
        String object = null;
        String defaultValue = null;
        String value = null;
        Node nameNode = rule.getAttributes().getNamedItem("name");
        if (nameNode != null) {
            name = nameNode.getNodeValue();
        }
        if ((objectNode = rule.getAttributes().getNamedItem("object")) != null) {
            object = objectNode.getNodeValue();
        }
        NodeList children = rule.getChildNodes();
        block8: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "defaultValue": {
                    defaultValue = child.getTextContent().trim();
                    continue block8;
                }
                case "value": {
                    value = child.getTextContent().trim();
                    continue block8;
                }
            }
        }
        return new Variable(name, object, defaultValue, value);
    }

    private RuleError parseRuleError(Node err) {
        String message = null;
        ArrayList<String> argument = new ArrayList<String>();
        NodeList children = err.getChildNodes();
        block8: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "message": {
                    message = child.getTextContent().trim();
                    continue block8;
                }
                case "argument": {
                    argument.add(child.getTextContent().trim());
                    continue block8;
                }
            }
        }
        return new RuleError(message, argument);
    }

    private Reference parseReference(Node ref) {
        String specification = null;
        String clause = null;
        ArrayList<Reference> references = new ArrayList<Reference>();
        NodeList children = ref.getChildNodes();
        block10: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "specification": {
                    specification = child.getTextContent().trim();
                    continue block10;
                }
                case "clause": {
                    clause = child.getTextContent().trim();
                    continue block10;
                }
                case "reference": {
                    references.add(this.parseReference(child));
                    continue block10;
                }
            }
        }
        return new Reference(specification, clause, references);
    }

    private Fix parseFix(Node fix) {
        String id = null;
        String description = null;
        FixInfo info = null;
        FixError error = null;
        Node idNode = fix.getAttributes().getNamedItem("id");
        if (idNode != null) {
            id = idNode.getNodeValue();
        }
        NodeList children = fix.getChildNodes();
        block10: for (int i = 0; i < children.getLength(); ++i) {
            String childName;
            Node child = children.item(i);
            switch (childName = child.getNodeName()) {
                case "description": {
                    description = child.getTextContent().trim();
                    continue block10;
                }
                case "info": {
                    int j;
                    NodeList nodelist = child.getChildNodes();
                    for (j = 0; j < nodelist.getLength(); ++j) {
                        if (!nodelist.item(j).getNodeName().equals("message")) continue;
                        info = new FixInfo(nodelist.item(j).getTextContent().trim());
                        continue block10;
                    }
                    continue block10;
                }
                case "error": {
                    int j;
                    NodeList nodelist = child.getChildNodes();
                    for (j = 0; j < nodelist.getLength(); ++j) {
                        if (!nodelist.item(j).getNodeName().equals("message")) continue;
                        error = new FixError(nodelist.item(j).getTextContent().trim());
                        continue block10;
                    }
                    continue block10;
                }
            }
        }
        return new Fix(id, description, info, error);
    }

    public static ValidationProfile parseValidationProfile(String resourcePath, boolean isSignCheckOn) throws ParserConfigurationException, SAXException, IOException, IncorrectImportPathException, MissedHashTagException, XMLStreamException, WrongSignatureException, WrongProfileEncodingException, NullProfileException {
        return ValidationProfileParser.parseValidationProfile(new File(resourcePath), isSignCheckOn);
    }

    public static ValidationProfile parseValidationProfile(File resourceFile, boolean isSignCheckOn) throws ParserConfigurationException, SAXException, IOException, IncorrectImportPathException, MissedHashTagException, XMLStreamException, WrongSignatureException, WrongProfileEncodingException, NullProfileException {
        return new ValidationProfileParser((File)resourceFile, (boolean)isSignCheckOn).profile;
    }
}

