/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.verapdf.features.pb.PBFeatureParser;
import org.verapdf.features.tools.FeaturesCollection;
import org.verapdf.gui.CheckerPanel;
import org.verapdf.model.ModelLoader;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosDocument;
import org.verapdf.validation.logic.Validator;
import org.verapdf.validation.report.model.ValidationInfo;

public class ValidateWorker
extends SwingWorker<ValidationInfo, Integer> {
    private static Logger logger = Logger.getLogger(ValidateWorker.class.getName());
    private File pdf;
    private File profile;
    private CheckerPanel parent;
    private FeaturesCollection collection;

    public ValidateWorker(CheckerPanel parent, File pdf, File profile) {
        this.parent = parent;
        this.pdf = pdf;
        this.profile = profile;
    }

    @Override
    protected ValidationInfo doInBackground() {
        ValidationInfo info = null;
        this.collection = null;
        ModelLoader loader = new ModelLoader(this.pdf.getPath());
        try {
            CosDocument root = loader.getRoot();
            try {
                info = Validator.validate((Object)root, (File)this.profile, (boolean)false);
            }
            catch (Exception e) {
                this.parent.errorInValidatingOccur("Some error in validating.", e);
            }
        }
        catch (Exception e) {
            this.parent.errorInValidatingOccur("Some error in parsing pdf.", e);
        }
        try {
            this.collection = PBFeatureParser.getFeaturesCollection((PDDocument)loader.getPDDocument());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.parent, "Some error in creating features collection.", "Error", 0);
            logger.log(Level.SEVERE, "Exception in creating features collection: ", e);
        }
        return info;
    }

    @Override
    protected void done() {
        this.parent.validationEnded(this.collection);
    }
}

