/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.report.model;

import org.verapdf.validation.report.model.Check;
import org.verapdf.validation.report.model.Details;
import org.verapdf.validation.report.model.Rule;
import org.verapdf.validation.report.model.Summary;

public class Result {
    private boolean compliant;
    private String statement;
    private Summary summary;
    private Details details;

    public Result(Details details) {
        int warnings;
        boolean compliantCheck = true;
        int passedRules = 0;
        int failedRules = 0;
        int passedChecks = 0;
        int failedChecks = 0;
        int completedMetadataFixes = 0;
        int failedMetadataFixes = 0;
        int n = warnings = details == null || details.getWarnings() == null ? 0 : details.getWarnings().size();
        if (details != null) {
            for (Rule rule : details.getRules()) {
                if (rule == null) continue;
                if ("passed".equals(rule.getAttrStatus())) {
                    ++passedRules;
                } else {
                    compliantCheck = false;
                    ++failedRules;
                }
                for (Check check : rule.getChecks()) {
                    if (check == null) continue;
                    if ("passed".equals(check.getAttrStatus())) {
                        ++passedChecks;
                        continue;
                    }
                    ++failedChecks;
                }
            }
        }
        this.compliant = compliantCheck;
        this.statement = compliantCheck ? "PDF file is compliant with Validation Profile requirements" : "PDF file is not compliant with Validation Profile requirements";
        this.summary = new Summary(passedRules, failedRules, passedChecks, failedChecks, completedMetadataFixes, failedMetadataFixes, warnings);
        this.details = details;
    }

    public boolean isCompliant() {
        return this.compliant;
    }

    public String getStatement() {
        return this.statement;
    }

    public Summary getSummary() {
        return this.summary;
    }

    public Details getDetails() {
        return this.details;
    }
}

