/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.xmp;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmpbox.XMPMetadata;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.factory.xmp.PBSchemaFactory;
import org.verapdf.model.impl.pb.xmp.PBXMPObject;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPSchema;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.model.xmplayer.XMPSchema;

public class PBXMPPackage
extends PBXMPObject
implements XMPPackage {
    private static final String XMPPACKAGE = "XMPPackage";
    private static final String SCHEMA = "Schemas";
    private XMPMetadata xmpMetadata;
    private boolean isMetadataValid;

    protected XMPMetadata getXmpMetadata() {
        return this.xmpMetadata;
    }

    public PBXMPPackage(XMPMetadata xmpMetadata, boolean isMetadataValid) {
        this.setType(XMPPACKAGE);
        this.xmpMetadata = xmpMetadata;
        this.isMetadataValid = isMetadataValid;
    }

    public Boolean getisMetadataValid() {
        return this.isMetadataValid;
    }

    public String getbytes() {
        return this.xmpMetadata == null ? null : this.xmpMetadata.getXpacketBytes();
    }

    public String getencoding() {
        return this.xmpMetadata == null ? null : this.xmpMetadata.getXpacketEncoding();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "Schemas": {
                list = this.getSchemas();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<XMPSchema> getSchemas() {
        ArrayList<XMPSchema> resultSchemas = new ArrayList<XMPSchema>();
        if (this.xmpMetadata != null && this.xmpMetadata.getAllSchemas() != null) {
            for (org.apache.xmpbox.schema.XMPSchema pbschema : this.xmpMetadata.getAllSchemas()) {
                if (pbschema == null) continue;
                PBXMPSchema schema = PBSchemaFactory.createSchema(pbschema);
                resultSchemas.add(schema);
            }
        }
        return resultSchemas;
    }
}

