/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.impl.pb.cos.PBCosStream;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.xmp.PBXMPMainPackage;
import org.verapdf.model.impl.pb.xmp.PBXMPPackage;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.xmplayer.XMPPackage;

public class PBoxPDMetadata
extends PBoxPDObject
implements PDMetadata {
    public static final Logger logger = Logger.getLogger(PBoxPDMetadata.class);
    public static final String XMP_PACKAGE = "XMPPackage";
    public static final String STREAM = "stream";
    private Boolean isMainMetadata;

    public PBoxPDMetadata(org.apache.pdfbox.pdmodel.common.PDMetadata simplePDObject, Boolean isMainMetadata) {
        super((COSObjectable)simplePDObject);
        this.isMainMetadata = isMainMetadata;
        this.setType("PDMetadata");
    }

    public String getFilter() {
        List filters = ((org.apache.pdfbox.pdmodel.common.PDMetadata)this.simplePDObject).getFilters();
        if (filters != null && filters.size() > 0) {
            StringBuilder result = new StringBuilder();
            for (COSName filter : filters) {
                result.append(filter.getName()).append(' ');
            }
            return result.substring(0, result.length() - 1);
        }
        return null;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "XMPPackage": {
                list = this.getXMPPackage();
                break;
            }
            case "stream": {
                list = this.getStream();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<XMPPackage> getXMPPackage() {
        ArrayList<XMPPackage> xmp = new ArrayList<XMPPackage>(1);
        try {
            COSStream stream = ((org.apache.pdfbox.pdmodel.common.PDMetadata)this.simplePDObject).getStream();
            if (stream != null) {
                DomXmpParser xmpParser = new DomXmpParser();
                XMPMetadata metadata = xmpParser.parse(stream.getUnfilteredStream());
                xmp.add(this.isMainMetadata != false ? new PBXMPMainPackage(metadata, true) : new PBXMPPackage(metadata, true));
            }
        }
        catch (XmpParsingException e) {
            logger.error((java.lang.Object)("Problems with parsing metadata. " + e.getMessage()));
            xmp.add(new PBXMPPackage(null, false));
        }
        catch (IOException e) {
            logger.error((java.lang.Object)("Metadata stream is closed. " + e.getMessage()));
            xmp.add(new PBXMPPackage(null, false));
        }
        return xmp;
    }

    private List<CosStream> getStream() {
        ArrayList<CosStream> streams = new ArrayList<CosStream>(1);
        COSStream stream = ((org.apache.pdfbox.pdmodel.common.PDMetadata)this.simplePDObject).getStream();
        streams.add(new PBCosStream(stream));
        return streams;
    }
}

