/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionNamed;
import org.apache.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.verapdf.model.impl.pb.pd.PBoxPDAcroForm;
import org.verapdf.model.impl.pb.pd.PBoxPDAction;
import org.verapdf.model.impl.pb.pd.PBoxPDMetadata;
import org.verapdf.model.impl.pb.pd.PBoxPDNamedAction;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.PBoxPDOutputIntent;
import org.verapdf.model.impl.pb.pd.PBoxPDPage;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDPage;

public class PBoxPDDocument
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDDocument {
    public static final Logger logger = Logger.getLogger(PBoxPDDocument.class);
    public static final String PAGES = "pages";
    public static final String METADATA = "metadata";
    public static final String OUTPUT_INTENTS = "outputIntents";
    public static final String ACRO_FORMS = "AcroForm";
    public static final String ACTIONS = "AA";
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OUTLINES = "Outlines";
    public static final Integer MAX_NUMBER_OF_ACTIONS = 5;

    public PBoxPDDocument(PDDocument document) {
        super(document);
        this.setType("PDDocument");
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "Outlines": {
                list = this.getOutlines();
                break;
            }
            case "OpenAction": {
                list = this.getOpenAction();
                break;
            }
            case "AA": {
                list = this.getActions();
                break;
            }
            case "pages": {
                list = this.getPages();
                break;
            }
            case "metadata": {
                list = this.getMetadata();
                break;
            }
            case "outputIntents": {
                list = this.getOutputIntents();
                break;
            }
            case "AcroForm": {
                list = this.getAcroForms();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<org.verapdf.model.baselayer.Object> getOutlines() {
        return new ArrayList<org.verapdf.model.baselayer.Object>();
    }

    private List<org.verapdf.model.pdlayer.PDAction> getOpenAction() {
        ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(1);
        try {
            PDDestinationOrAction openAction = this.document.getDocumentCatalog().getOpenAction();
            if (openAction instanceof PDActionNamed) {
                actions.add(new PBoxPDNamedAction((PDActionNamed)openAction));
            } else if (openAction instanceof PDAction) {
                actions.add(new PBoxPDAction((PDAction)openAction));
            }
        }
        catch (IOException e) {
            logger.error((Object)("Problems with open action obtaining. " + e.getMessage()));
        }
        return actions;
    }

    private List<org.verapdf.model.pdlayer.PDAction> getActions() {
        ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(MAX_NUMBER_OF_ACTIONS);
        PDDocumentCatalogAdditionalActions pbActions = this.document.getDocumentCatalog().getActions();
        if (pbActions != null) {
            PDAction buffer = pbActions.getDP();
            this.addAction(actions, buffer);
            buffer = pbActions.getDS();
            this.addAction(actions, buffer);
            buffer = pbActions.getWP();
            this.addAction(actions, buffer);
            buffer = pbActions.getWS();
            this.addAction(actions, buffer);
            buffer = pbActions.getWC();
            this.addAction(actions, buffer);
        }
        return actions;
    }

    private List<PDPage> getPages() {
        PDPageTree pageTree = this.document.getPages();
        ArrayList<PDPage> pages = new ArrayList<PDPage>(pageTree.getCount());
        for (org.apache.pdfbox.pdmodel.PDPage page : pageTree) {
            if (page == null) continue;
            pages.add(new PBoxPDPage(page));
        }
        return pages;
    }

    private List<PDMetadata> getMetadata() {
        ArrayList<PDMetadata> metadata = new ArrayList<PDMetadata>(1);
        org.apache.pdfbox.pdmodel.common.PDMetadata meta = this.document.getDocumentCatalog().getMetadata();
        if (meta != null && meta.getCOSObject() != null) {
            metadata.add(new PBoxPDMetadata(meta, Boolean.TRUE));
        }
        return metadata;
    }

    private List<org.verapdf.model.pdlayer.PDOutputIntent> getOutputIntents() {
        ArrayList<org.verapdf.model.pdlayer.PDOutputIntent> outputIntents = new ArrayList<org.verapdf.model.pdlayer.PDOutputIntent>();
        List pdfboxOutputIntents = this.document.getDocumentCatalog().getOutputIntents();
        for (PDOutputIntent intent : pdfboxOutputIntents) {
            if (intent == null) continue;
            outputIntents.add(new PBoxPDOutputIntent(intent));
        }
        return outputIntents;
    }

    private List<PDAcroForm> getAcroForms() {
        ArrayList<PDAcroForm> forms = new ArrayList<PDAcroForm>();
        org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm form = this.document.getDocumentCatalog().getAcroForm();
        if (form != null) {
            forms.add(new PBoxPDAcroForm(form));
        }
        return forms;
    }
}

