/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.factory.operator.OperatorFactory;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.pdlayer.PDContentStream;

public class PBoxPDContentStream
extends PBoxPDObject
implements PDContentStream {
    public static final Logger logger = Logger.getLogger(PBoxPDContentStream.class);
    public static final String OPERATORS = "operators";

    public PBoxPDContentStream(org.apache.pdfbox.contentstream.PDContentStream contentStream) {
        super(contentStream);
        this.setType("PDContentStream");
    }

    public List<? extends Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "operators": {
                list = this.getOperators();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<Operator> getOperators() {
        List<Operator> result = new ArrayList<Operator>();
        try {
            PDFStreamParser streamParser = new PDFStreamParser(this.contentStream.getContentStream(), true);
            streamParser.parse();
            result = OperatorFactory.parseOperators(streamParser.getTokens(), this.contentStream.getResources());
        }
        catch (IOException e) {
            logger.error((java.lang.Object)("Error while parsing content stream." + e.getMessage()));
        }
        return result;
    }
}

