/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.impl.pb.cos.PBCosDict;

public class PBCosStream
extends PBCosDict
implements CosStream {
    public PBCosStream(COSStream stream) {
        super((COSDictionary)stream);
        this.setType("CosStream");
    }

    public Long getLength() {
        COSBase number = ((COSStream)this.baseObject).getDictionaryObject(COSName.LENGTH);
        return number instanceof COSNumber ? Long.valueOf(((COSNumber)number).longValue()) : null;
    }

    public String getfilters() {
        COSBase base = ((COSStream)this.baseObject).getFilters();
        return this.getFilters(base);
    }

    private String getFilters(COSBase base) {
        StringBuilder filters = new StringBuilder();
        if (base == null) {
            return null;
        }
        if (base instanceof COSName) {
            return ((COSName)base).getName();
        }
        if (base instanceof COSArray) {
            for (COSBase filter : (COSArray)base) {
                if (filter instanceof COSName) {
                    filters.append(((COSName)filter).getName()).append(" ");
                    continue;
                }
                throw new IllegalArgumentException("Can`t find filters for stream");
            }
        } else {
            throw new IllegalArgumentException("Not the corresponding type for filters");
        }
        return filters.substring(0, filters.length() - 1);
    }

    public String getF() {
        COSBase fileSpecification = ((COSStream)this.baseObject).getItem("F");
        return fileSpecification != null ? fileSpecification.toString() : null;
    }

    public String getFFilter() {
        COSBase base = ((COSStream)this.baseObject).getDictionaryObject(COSName.F_FILTER);
        return this.getFilters(base);
    }

    public String getFDecodeParms() {
        COSBase fDecodeParms = ((COSStream)this.baseObject).getItem("FDecodeParms");
        return fDecodeParms != null ? fDecodeParms.toString() : null;
    }

    public Boolean getspacingCompliesPDFA() {
        return ((COSStream)this.baseObject).getStreamSpacingsComplyPDFA() != false && ((COSStream)this.baseObject).getEndStreamSpacingsComplyPDFA() != false;
    }

    public Boolean getisLengthCorrect() {
        Long keyValue = this.getLength();
        Long realValue = ((COSStream)this.baseObject).getOriginLength();
        return keyValue != null && keyValue.equals(realValue);
    }
}

