/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.factory.xmp;

import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.PDFAExtensionSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.PhotoshopSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.schema.XMPMediaManagementSchema;
import org.apache.xmpbox.schema.XMPRightsManagementSchema;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.schema.XMPageTextSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBAUXSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBCRSSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBPDFAExtensionSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBPDFAIdSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBPDFSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBPhotoshopSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXAPSSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPBasicSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPCustomSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPDMSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPMMSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPPredefinedSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPRightsSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPSchema;
import org.verapdf.model.impl.pb.xmp.schemas.PBXMPTPgSchema;
import org.verapdf.model.tools.XMPHelper;

public final class PBSchemaFactory {
    private PBSchemaFactory() {
    }

    public static PBXMPSchema createSchema(XMPSchema schema) {
        PBXMPSchema resultSchema;
        switch (schema.getNamespace()) {
            case "http://www.aiim.org/pdfa/ns/id/": {
                if (schema instanceof PDFAIdentificationSchema) {
                    resultSchema = new PBPDFAIdSchema((PDFAIdentificationSchema)schema);
                    break;
                }
                throw PBSchemaFactory.getSchemaException(schema, "PDFAIdentificationSchema");
            }
            case "http://www.aiim.org/pdfa/ns/extension/": {
                if (schema instanceof PDFAExtensionSchema) {
                    resultSchema = new PBPDFAExtensionSchema((PDFAExtensionSchema)schema);
                    break;
                }
                throw PBSchemaFactory.getSchemaException(schema, "PDFAExtensionSchema");
            }
            case "http://ns.adobe.com/xap/1.0/": {
                if (schema instanceof XMPBasicSchema) {
                    resultSchema = new PBXMPBasicSchema((XMPBasicSchema)schema);
                    break;
                }
                throw PBSchemaFactory.getSchemaException(schema, "XMPBasicSchema");
            }
            case "http://ns.adobe.com/xap/1.0/rights/": {
                if (schema instanceof XMPRightsManagementSchema) {
                    resultSchema = new PBXMPRightsSchema((XMPRightsManagementSchema)schema);
                    break;
                }
                throw PBSchemaFactory.getSchemaException(schema, "XMPRightsManagementSchema");
            }
            case "http://ns.adobe.com/xap/1.0/mm/": {
                if (schema instanceof XMPMediaManagementSchema) {
                    resultSchema = new PBXMPMMSchema((XMPMediaManagementSchema)schema);
                    break;
                }
                throw PBSchemaFactory.getSchemaException(schema, "XMPMediaManagementSchema");
            }
            case "http://ns.adobe.com/xap/1.0/t/pg/": {
                if (schema instanceof XMPageTextSchema) {
                    resultSchema = new PBXMPTPgSchema((XMPageTextSchema)schema);
                    break;
                }
                throw PBSchemaFactory.getSchemaException(schema, "XMPageTextSchema");
            }
            case "http://ns.adobe.com/pdf/1.3/": {
                if (schema instanceof AdobePDFSchema) {
                    resultSchema = new PBPDFSchema((AdobePDFSchema)schema);
                    break;
                }
                throw PBSchemaFactory.getSchemaException(schema, "AdobePDFSchema");
            }
            case "http://ns.adobe.com/photoshop/1.0/": {
                if (schema instanceof PhotoshopSchema) {
                    resultSchema = new PBPhotoshopSchema((PhotoshopSchema)schema);
                    break;
                }
                throw PBSchemaFactory.getSchemaException(schema, "PhotoshopSchema");
            }
            case "http://ns.adobe.com/camera-rawsettings/1.0/": {
                resultSchema = new PBCRSSchema(schema);
                break;
            }
            case "http://ns.adobe.com/exif/1.0/aux/": {
                resultSchema = new PBAUXSchema(schema);
                break;
            }
            case "http://ns.adobe.com/xmp/1.0/DynamicMedia/": {
                resultSchema = new PBXMPDMSchema(schema);
                break;
            }
            case "http://ns.adobe.com/xap/1.0/s/": {
                resultSchema = new PBXAPSSchema(schema);
                break;
            }
            default: {
                resultSchema = XMPHelper.isPredifinedSchema(schema.getNamespace()) ? new PBXMPPredefinedSchema(schema) : new PBXMPCustomSchema(schema);
            }
        }
        return resultSchema;
    }

    private static ClassCastException getSchemaException(XMPSchema schema, String className) {
        return new ClassCastException("Schema with namespace " + schema.getNamespace() + "must be " + className + "class. Real class: " + schema.getClass().getName() + ".");
    }
}

