/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBMetadataFeaturesObject
implements IFeaturesObject {
    private PDMetadata metadata;

    public PBMetadataFeaturesObject(PDMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.METADATA;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.metadata != null) {
            FeatureTreeNode root = FeatureTreeNode.newInstance("metadata", null);
            try {
                String metadataString = this.metadata.getInputStreamAsString();
                root.setValue(metadataString);
            }
            catch (IOException e) {
                root.addAttribute("errorId", "metaerr1");
                ErrorsHelper.addErrorIntoCollection(collection, "metaerr1", "Error while converting metadata stream with use of ISO-8859-1 encoding.");
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.METADATA, root);
            return root;
        }
        return null;
    }
}

