/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.tools.IDGenerator;
import org.verapdf.model.visitor.cos.pb.PBCosVisitor;

public class PBCosObject
extends GenericModelObject
implements CosObject {
    private static Logger logger = Logger.getLogger(PBCosObject.class);
    protected COSBase baseObject;
    private String type = "CosObject";
    private String id;

    public PBCosObject(COSBase baseObject) {
        this.baseObject = baseObject;
        this.id = IDGenerator.generateID(this.baseObject);
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public String getID() {
        return this.id;
    }

    public static CosObject getFromValue(COSBase base) {
        try {
            if (base != null) {
                PBCosVisitor visitor = PBCosVisitor.getInstance();
                if (base instanceof COSObject) {
                    return (CosObject)visitor.visitFromObject((COSObject)base);
                }
                return (CosObject)base.accept((ICOSVisitor)visitor);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Problems with wrapping pdfbox object \"" + base.toString() + "\". " + e.getMessage()));
        }
        return null;
    }
}

