/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.verapdf.model.coslayer.CosDocument;
import org.verapdf.model.coslayer.CosIndirect;
import org.verapdf.model.coslayer.CosTrailer;
import org.verapdf.model.impl.pb.cos.PBCosFileSpecification;
import org.verapdf.model.impl.pb.cos.PBCosIndirect;
import org.verapdf.model.impl.pb.cos.PBCosObject;
import org.verapdf.model.impl.pb.cos.PBCosTrailer;
import org.verapdf.model.impl.pb.cos.PBCosXRef;
import org.verapdf.model.impl.pb.pd.PBoxPDDocument;
import org.verapdf.model.tools.XMPChecker;

public class PBCosDocument
extends PBCosObject
implements CosDocument {
    private static final Logger logger = Logger.getLogger(PBCosDocument.class);
    public static final String TRAILER = "trailer";
    public static final String XREF = "xref";
    public static final String INDIRECT_OBJECTS = "indirectObjects";
    public static final String DOCUMENT = "document";
    public static final String EMBEDDED_FILES = "EmbeddedFiles";
    public static final String ID = "ID";
    private PDDocument pdDocument;
    private Long sizeOfDocument = -1L;

    public PBCosDocument(COSDocument baseObject) {
        super((COSBase)baseObject);
        this.setType("CosDocument");
    }

    public PBCosDocument(PDDocument pdDocument, long length) {
        super((COSBase)pdDocument.getDocument());
        this.setType("CosDocument");
        this.pdDocument = pdDocument;
        this.sizeOfDocument = length;
    }

    public Long getnrIndirects() {
        return ((COSDocument)this.baseObject).getObjects().size();
    }

    public Double getversion() {
        return ((COSDocument)this.baseObject).getVersion();
    }

    public Long getsize() {
        return this.sizeOfDocument;
    }

    public Boolean getbinaryHeaderComplyPDFA() {
        return ((COSDocument)this.baseObject).getNonValidCommentContent() == false && ((COSDocument)this.baseObject).getNonValidCommentLength() == false && ((COSDocument)this.baseObject).getNonValidCommentStart() == false;
    }

    public Boolean getpdfHeaderCompliesPDFA() {
        return ((COSDocument)this.baseObject).getNonValidHeader() == false;
    }

    public Boolean getisOptionalContentPresent() {
        try {
            COSDictionary root = (COSDictionary)((COSDocument)this.baseObject).getCatalog().getObject();
            return root.getItem(COSName.OCPROPERTIES) != null;
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
    }

    public Boolean geteofCompliesPDFA() {
        return ((COSDocument)this.baseObject).getEofComplyPDFA();
    }

    public String getfirstPageID() {
        return this.getTrailerID((COSArray)((COSDocument)this.baseObject).getFirstPageTrailer().getItem(ID));
    }

    public String getlastID() {
        return this.getTrailerID((COSArray)((COSDocument)this.baseObject).getLastTrailer().getItem(ID));
    }

    private String getTrailerID(COSArray ids) {
        if (ids != null) {
            StringBuilder builder = new StringBuilder();
            for (COSBase id : ids) {
                byte[] arr$ = ((COSString)id).getBytes();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Byte aByte = arr$[i$];
                    builder.append((char)(aByte & 0xFF));
                }
                builder.append(' ');
            }
            return builder.toString().substring(0, builder.length() - 1);
        }
        return null;
    }

    public Boolean getisLinearized() {
        COSDocument document = (COSDocument)this.baseObject;
        boolean res = document.getTrailer() != document.getLastTrailer() && document.isLinearized() != false;
        return res;
    }

    public Boolean getdoesInfoMatchXMP() {
        return XMPChecker.doesInfoMatchXMP((COSDocument)this.baseObject);
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        List list;
        switch (link) {
            case "trailer": {
                list = this.getTrailer();
                break;
            }
            case "indirectObjects": {
                list = this.getIndirectObjects();
                break;
            }
            case "document": {
                list = this.getDocument();
                break;
            }
            case "xref": {
                list = this.getXRef();
                break;
            }
            case "EmbeddedFiles": {
                list = this.getEmbeddedFiles();
                break;
            }
            default: {
                list = super.getLinkedObjects(link);
            }
        }
        return list;
    }

    private List<org.verapdf.model.baselayer.Object> getEmbeddedFiles() {
        ArrayList<org.verapdf.model.baselayer.Object> files = new ArrayList<org.verapdf.model.baselayer.Object>();
        try {
            COSDictionary buffer = (COSDictionary)this.pdDocument.getDocument().getCatalog().getObject();
            buffer = this.getCosDictionary(buffer.getItem(COSName.NAMES));
            if (buffer != null) {
                buffer = this.getCosDictionary(buffer.getItem(COSName.EMBEDDED_FILES));
            }
            this.getNamesEmbeddedFiles(files, buffer);
        }
        catch (IOException e) {
            logger.error((Object)("Something wrong with getting embedded files - return empty list. " + e.getMessage()));
        }
        return files;
    }

    private void getNamesEmbeddedFiles(List<org.verapdf.model.baselayer.Object> files, COSDictionary buffer) throws IOException {
        PDEmbeddedFilesNameTreeNode root = null;
        if (buffer != null) {
            root = new PDEmbeddedFilesNameTreeNode(buffer);
        }
        if (root != null) {
            Set entries = root.getNames().entrySet();
            for (Map.Entry entry : entries) {
                files.add((org.verapdf.model.baselayer.Object)new PBCosFileSpecification(((PDComplexFileSpecification)entry.getValue()).getCOSObject()));
            }
        }
    }

    private COSDictionary getCosDictionary(COSBase item) throws IOException {
        COSDictionary buffer = null;
        if (item instanceof COSDictionary) {
            buffer = (COSDictionary)item;
        } else if (item instanceof COSObject) {
            buffer = (COSDictionary)((COSObject)item).getObject();
        }
        return buffer;
    }

    private List<CosTrailer> getTrailer() {
        ArrayList<CosTrailer> trailer = new ArrayList<CosTrailer>();
        trailer.add(new PBCosTrailer(((COSDocument)this.baseObject).getTrailer()));
        return trailer;
    }

    private List<CosIndirect> getIndirectObjects() {
        ArrayList<CosIndirect> indirects = new ArrayList<CosIndirect>();
        for (COSBase object : ((COSDocument)this.baseObject).getObjects()) {
            indirects.add(new PBCosIndirect(object));
        }
        return indirects;
    }

    private List<org.verapdf.model.pdlayer.PDDocument> getDocument() {
        ArrayList<org.verapdf.model.pdlayer.PDDocument> document = new ArrayList<org.verapdf.model.pdlayer.PDDocument>(1);
        document.add(new PBoxPDDocument(this.pdDocument));
        return document;
    }

    private List<? extends org.verapdf.model.baselayer.Object> getXRef() {
        ArrayList<PBCosXRef> xref = new ArrayList<PBCosXRef>();
        COSDocument document = (COSDocument)this.baseObject;
        xref.add(new PBCosXRef(document.isXRefSpacingsCompliesPDFA(), document.isXRefEOLCompliesPDFA()));
        return xref;
    }
}

