/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBPageFeaturesObject
implements IFeaturesObject {
    private static final String PAGE = "page";
    private static final String LLX = "llx";
    private static final String LLY = "lly";
    private static final String URX = "urx";
    private static final String URY = "ury";
    private PDPage page;
    private int index;

    public PBPageFeaturesObject(PDPage page, int index) {
        this.page = page;
        this.index = index;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.PAGE;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.page != null) {
            FeatureTreeNode root = FeatureTreeNode.newInstance(PAGE, null);
            root.addAttribute("id", PAGE + this.index);
            root.addAttribute("orderNumber", Integer.toString(this.index));
            this.addBoxFeature("mediaBox", this.page.getMediaBox(), root);
            this.addBoxFeature("cropBox", this.page.getCropBox(), root);
            this.addBoxFeature("trimBox", this.page.getTrimBox(), root);
            this.addBoxFeature("bleedBox", this.page.getBleedBox(), root);
            this.addBoxFeature("artBox", this.page.getArtBox(), root);
            FeatureTreeNode.newInstance("rotation", Integer.toString(this.page.getRotation()), root);
            COSBase base = this.page.getCOSObject().getDictionaryObject(COSName.getPDFName((String)"PZ"));
            if (base != null) {
                FeatureTreeNode scaling = FeatureTreeNode.newInstance("scaling", root);
                while (base instanceof COSObject) {
                    base = ((COSObject)base).getObject();
                }
                if (base instanceof COSNumber) {
                    COSNumber number = (COSNumber)base;
                    scaling.setValue(String.valueOf(number.doubleValue()));
                } else {
                    scaling.addAttribute("errorId", "pageerr1");
                    ErrorsHelper.addErrorIntoCollection(collection, "pageerr1", "Page dictionary must contain number value for key \"PZ\".");
                }
            }
            FeatureTreeNode.newInstance("thumbnail", Boolean.toString(this.page.getCOSObject().getDictionaryObject(COSName.getPDFName((String)"Thumb")) != null), root);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.PAGE, root);
            return root;
        }
        return null;
    }

    private void addBoxFeature(String name, PDRectangle box, FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (box != null) {
            FeatureTreeNode boxNode = FeatureTreeNode.newInstance(name, root);
            boxNode.addAttribute(LLX, String.valueOf(box.getLowerLeftX()));
            boxNode.addAttribute(LLY, String.valueOf(box.getLowerLeftY()));
            boxNode.addAttribute(URX, String.valueOf(box.getUpperRightX()));
            boxNode.addAttribute(URY, String.valueOf(box.getUpperRightY()));
        }
    }
}

