/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TreeSet;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBInfoDictFeaturesObject
implements IFeaturesObject {
    private static final String[] predefinedKeys = new String[]{"Title", "Author", "Subject", "Keywords", "Creator", "Producer", "CreationDate", "ModDate", "Trapped"};
    private static final String ENTRY = "entry";
    private static final String KEY = "key";
    private PDDocumentInformation info;

    public PBInfoDictFeaturesObject(PDDocumentInformation info) {
        this.info = info;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.INFORMATION_DICTIONARY;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.info != null) {
            FeatureTreeNode root = FeatureTreeNode.newInstance("informationDict", null);
            this.addEntry("Title", this.info.getTitle(), root);
            this.addEntry("Author", this.info.getAuthor(), root);
            this.addEntry("Subject", this.info.getSubject(), root);
            this.addEntry("Keywords", this.info.getKeywords(), root);
            this.addEntry("Creator", this.info.getCreator(), root);
            this.addEntry("Producer", this.info.getProducer(), root);
            if (this.info.getCreationDate() != null) {
                FeatureTreeNode creationDate = FeatureTreeNode.newInstance(ENTRY, root);
                creationDate.addAttribute(KEY, "CreationDate");
                try {
                    creationDate.setValue(this.getXMLFormat(this.info.getCreationDate()));
                }
                catch (DatatypeConfigurationException e) {
                    creationDate.addAttribute("errorId", "infodicterr1");
                    ErrorsHelper.addErrorIntoCollection(collection, "infodicterr1", "A serious configuration error while creating creationDate field in information dictionary features.");
                }
            }
            if (this.info.getModificationDate() != null) {
                FeatureTreeNode modificationDate = FeatureTreeNode.newInstance(ENTRY, root);
                modificationDate.addAttribute(KEY, "ModDate");
                try {
                    modificationDate.setValue(this.getXMLFormat(this.info.getModificationDate()));
                }
                catch (DatatypeConfigurationException e) {
                    modificationDate.addAttribute("errorId", "infodicterr2");
                    ErrorsHelper.addErrorIntoCollection(collection, "infodicterr2", "A serious configuration error while creating modDate field in information dictionary features.");
                }
            }
            this.addEntry("Trapped", this.info.getTrapped(), root);
            if (this.info.getMetadataKeys() != null) {
                TreeSet keys = new TreeSet(this.info.getMetadataKeys());
                keys.removeAll(Arrays.asList(predefinedKeys));
                for (String key : keys) {
                    this.addEntry(key, this.info.getCustomMetadataValue(key), root);
                }
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.INFORMATION_DICTIONARY, root);
            return root;
        }
        return null;
    }

    private void addEntry(String name, String value, FeatureTreeNode root) throws FeaturesTreeNodeException {
        if (name != null && value != null) {
            FeatureTreeNode entry = FeatureTreeNode.newInstance(ENTRY, value, root);
            entry.addAttribute(KEY, name);
        }
    }

    private String getXMLFormat(Calendar calendar) throws DatatypeConfigurationException {
        GregorianCalendar greg = new GregorianCalendar();
        greg.setTime(calendar.getTime());
        greg.setTimeZone(calendar.getTimeZone());
        XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(greg);
        return xmlCalendar.toXMLFormat();
    }
}

