/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class LogoPanel
extends JPanel {
    private final BufferedImage logo;
    private int borderWidth;
    private Color background;

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int imageHeight = this.getHeight() - this.borderWidth * 2;
        int imageWidth = this.logo.getWidth() * imageHeight / this.logo.getHeight();
        int imageStartY = this.borderWidth;
        int imageStartX = (this.getWidth() - imageWidth) / 2;
        g.setColor(this.background);
        g.drawImage(this.logo, imageStartX, imageStartY, imageStartX + imageWidth, imageStartY + imageHeight, 0, 0, this.logo.getWidth(), this.logo.getHeight(), this);
    }

    public LogoPanel(String logoName, Color backgroundColor, int borderWidth) throws IOException {
        this.borderWidth = borderWidth;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(logoName);
        this.logo = ImageIO.read(is);
        this.background = backgroundColor;
        this.setLayout(null);
        this.setBackground(backgroundColor);
        this.setPreferredSize(new Dimension(450, 200));
    }
}

