/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.verapdf.features.tools.FeaturesCollection;
import org.verapdf.gui.LogoPanel;
import org.verapdf.gui.ValidateWorker;
import org.verapdf.gui.tools.GUIConstants;
import org.verapdf.report.HTMLReport;
import org.verapdf.report.XMLReport;
import org.verapdf.validation.report.model.ValidationInfo;

public class CheckerPanel
extends JPanel {
    private static Logger logger = Logger.getLogger(CheckerPanel.class.getName());
    private JFileChooser pdfChooser;
    private JFileChooser xmlChooser;
    private JFileChooser htmlChooser;
    private File pdfFile;
    private File profile;
    private JTextField chosenPDF;
    private JTextField chosenProfile;
    private JLabel result;
    private ValidationInfo info;
    private File xmlReport;
    private File htmlReport;
    private File image = null;
    private long startTimeOfValidation;
    private long endTimeOfValidation;
    private boolean isValidationErrorOccurred;
    private JButton validate;
    private JButton saveXML;
    private JButton viewXML;
    private JButton saveHTML;
    private JButton viewHTML;
    private JProgressBar progressBar;
    private ValidateWorker validateWorker;

    public CheckerPanel() throws IOException {
        this.setPreferredSize(new Dimension(450, 200));
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        this.chosenPDF = new JTextField("PDF file not chosen");
        this.chosenPDF.setEditable(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 0, 3, 1, 3, 1, 2);
        gbl.setConstraints(this.chosenPDF, gbc);
        this.add(this.chosenPDF);
        JButton choosePDF = new JButton("Choose PDF");
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 0, 0, 1, 1, 1, 2);
        gbl.setConstraints(choosePDF, gbc);
        this.add(choosePDF);
        this.chosenProfile = new JTextField("Validation profile not chosen");
        this.chosenProfile.setEditable(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 1, 3, 1, 3, 1, 2);
        gbl.setConstraints(this.chosenProfile, gbc);
        this.add(this.chosenProfile);
        JButton chooseProfile = new JButton("Choose Profile");
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 1, 0, 1, 1, 1, 2);
        gbl.setConstraints(chooseProfile, gbc);
        this.add(chooseProfile);
        this.result = new JLabel();
        this.result.setForeground(GUIConstants.BEFORE_VALIDATION_COLOR);
        this.result.setHorizontalTextPosition(0);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 2, 3, 1, 3, 1, 10);
        gbl.setConstraints(this.result, gbc);
        this.add(this.result);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 2, 3, 1, 3, 1, 2);
        gbl.setConstraints(this.progressBar, gbc);
        this.add(this.progressBar);
        this.validate = new JButton("Validate");
        this.validate.setEnabled(false);
        CheckerPanel.setGridBagConstraintsParameters(gbc, 3, 2, 0, 1, 1, 1, 2);
        gbl.setConstraints(this.validate, gbc);
        this.add(this.validate);
        JPanel reports = new JPanel();
        reports.setBorder(BorderFactory.createTitledBorder("Report"));
        reports.setLayout(new GridLayout(2, 3));
        CheckerPanel.setGridBagConstraintsParameters(gbc, 0, 3, 4, 3, 4, 1, 2);
        gbl.setConstraints(reports, gbc);
        this.add(reports);
        LogoPanel xmlLogo = new LogoPanel("xml-logo.png", reports.getBackground(), 4);
        reports.add(xmlLogo);
        this.saveXML = new JButton("Save XML");
        this.saveXML.setEnabled(false);
        reports.add(this.saveXML);
        this.viewXML = new JButton("View XML");
        this.viewXML.setEnabled(false);
        reports.add(this.viewXML);
        LogoPanel htmlLogo = new LogoPanel("html-logo.png", reports.getBackground(), 4);
        reports.add(htmlLogo);
        this.saveHTML = new JButton("Save HTML");
        this.saveHTML.setEnabled(false);
        gbc.fill = 2;
        reports.add(this.saveHTML);
        this.viewHTML = new JButton("View HTML");
        this.viewHTML.setEnabled(false);
        reports.add(this.viewHTML);
        this.pdfChooser = this.getChooser("pdf");
        this.xmlChooser = this.getChooser("xml");
        this.htmlChooser = this.getChooser("html");
        choosePDF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.chooseFile(CheckerPanel.this.pdfChooser, "pdf");
            }
        });
        chooseProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.chooseFile(CheckerPanel.this.xmlChooser, "xml");
            }
        });
        this.validate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.progressBar.setVisible(true);
                CheckerPanel.this.result.setVisible(false);
                CheckerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                CheckerPanel.this.validate.setEnabled(false);
                CheckerPanel.this.info = null;
                CheckerPanel.this.isValidationErrorOccurred = false;
                CheckerPanel.this.startTimeOfValidation = System.currentTimeMillis();
                CheckerPanel.this.validateWorker = new ValidateWorker(CheckerPanel.this, CheckerPanel.this.pdfFile, CheckerPanel.this.profile);
                CheckerPanel.this.validateWorker.execute();
            }
        });
        this.saveXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.saveReport(CheckerPanel.this.xmlChooser, "xml", CheckerPanel.this.xmlReport);
            }
        });
        this.saveHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckerPanel.this.saveReport(CheckerPanel.this.htmlChooser, "html", CheckerPanel.this.htmlReport);
            }
        });
        this.viewXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckerPanel.this.xmlReport == null) {
                    JOptionPane.showMessageDialog(CheckerPanel.this, "XML report hasn't been saved.", "Error", 0);
                } else {
                    try {
                        Desktop.getDesktop().open(CheckerPanel.this.xmlReport);
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(CheckerPanel.this, "Some error in opening the XML report.", "Error", 0);
                        logger.log(Level.SEVERE, "Exception in opening the XML report: ", e);
                    }
                }
            }
        });
        this.viewHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckerPanel.this.htmlReport == null) {
                    JOptionPane.showMessageDialog(CheckerPanel.this, "HTML report hasn't been saved.", "Error", 0);
                } else {
                    try {
                        Desktop.getDesktop().open(CheckerPanel.this.htmlReport);
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(CheckerPanel.this, "Some error in opening the HTML report.", "Error", 0);
                        logger.log(Level.SEVERE, "Exception in opening the HTML report: ", e);
                    }
                }
            }
        });
    }

    public void validationEnded(FeaturesCollection collection) {
        this.endTimeOfValidation = System.currentTimeMillis();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setVisible(false);
        if (!this.isValidationErrorOccurred) {
            try {
                this.info = (ValidationInfo)this.validateWorker.get();
                if (this.info.getResult().isCompliant()) {
                    this.result.setForeground(GUIConstants.VALIDATION_SUCCESS_COLOR);
                    this.result.setText("PDF file is compliant with Validation Profile requirements");
                } else {
                    this.result.setForeground(GUIConstants.VALIDATION_FAILED_COLOR);
                    this.result.setText("PDF file is not compliant with Validation Profile requirements");
                }
                this.result.setVisible(true);
            }
            catch (InterruptedException e) {
                this.errorInValidatingOccur("Validation has interrupted.", e);
            }
            catch (ExecutionException e) {
                this.errorInValidatingOccur("Execution exception in validating.", e);
            }
        }
        this.writeReports(collection);
    }

    private void writeReports(FeaturesCollection collection) {
        try {
            File dir = new File("./temp/");
            if (!dir.exists() && !dir.mkdir()) {
                throw new IOException("Can not create temporary directory.");
            }
            this.xmlReport = new File("./temp/tempXMLReport.xml");
            XMLReport.writeXMLReport((ValidationInfo)this.info, (FeaturesCollection)collection, (String)this.xmlReport.getPath(), (long)(this.endTimeOfValidation - this.startTimeOfValidation));
            this.saveXML.setEnabled(true);
            this.viewXML.setEnabled(true);
            if (this.info != null) {
                try {
                    this.htmlReport = new File("./temp/tempHTMLReport.html");
                    HTMLReport.writeHTMLReport((String)this.htmlReport.getPath(), (File)this.xmlReport, (File)this.profile);
                    if (this.image == null) {
                        this.image = new File("./temp/" + HTMLReport.getLogoImageName());
                    }
                    this.saveHTML.setEnabled(true);
                    this.viewHTML.setEnabled(true);
                }
                catch (IOException | TransformerException e) {
                    JOptionPane.showMessageDialog(this, "Some error in saving the HTML report.", "Error", 0);
                    logger.log(Level.SEVERE, "Exception in saving HTML report: ", e);
                }
            }
        }
        catch (IOException | DatatypeConfigurationException | ParserConfigurationException | TransformerException e) {
            JOptionPane.showMessageDialog(this, "Some error in saving the XML report.", "Error", 0);
            logger.log(Level.SEVERE, "Exception in saving XML report: ", e);
        }
    }

    public void errorInValidatingOccur(String message, Throwable e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setVisible(false);
        this.isValidationErrorOccurred = true;
        JOptionPane.showMessageDialog(this, message, "Error", 0);
        logger.log(Level.SEVERE, "Exception in validating process: ", e);
        this.result.setForeground(GUIConstants.VALIDATION_FAILED_COLOR);
        this.result.setText(message);
        this.result.setVisible(true);
    }

    private JFileChooser getChooser(String type) throws IOException {
        JFileChooser res = new JFileChooser();
        File currentDir = new File(new File(".").getCanonicalPath());
        res.setCurrentDirectory(currentDir);
        res.setAcceptAllFileFilterUsed(false);
        res.setFileFilter(new FileNameExtensionFilter(type, type));
        return res;
    }

    private static void setGridBagConstraintsParameters(GridBagConstraints gbc, int gridx, int gridy, int weightx, int weighty, int gridwidth, int gridheight, int fill) {
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
    }

    private void chooseFile(JFileChooser chooser, String extension) {
        int resultChoose = chooser.showOpenDialog(this);
        if (resultChoose == 0) {
            if (!chooser.getSelectedFile().exists()) {
                JOptionPane.showMessageDialog(this, "Error. Selected file doesn't exist.", "Error", 0);
            } else if (!chooser.getSelectedFile().getName().toLowerCase().endsWith("." + extension.toLowerCase())) {
                JOptionPane.showMessageDialog(this, "Error. Selected file is not in " + extension.toUpperCase() + " format.", "Error", 0);
            } else {
                this.info = null;
                this.result.setForeground(GUIConstants.BEFORE_VALIDATION_COLOR);
                this.result.setText("");
                this.xmlReport = null;
                this.htmlReport = null;
                this.saveXML.setEnabled(false);
                this.viewXML.setEnabled(false);
                this.saveHTML.setEnabled(false);
                this.viewHTML.setEnabled(false);
                switch (extension) {
                    case "pdf": {
                        this.pdfFile = chooser.getSelectedFile();
                        this.chosenPDF.setText(this.pdfFile.getAbsolutePath());
                        if (this.profile == null) break;
                        this.validate.setEnabled(true);
                        break;
                    }
                    case "xml": {
                        this.profile = chooser.getSelectedFile();
                        this.chosenProfile.setText(this.profile.getAbsolutePath());
                        if (this.pdfFile == null) break;
                        this.validate.setEnabled(true);
                        break;
                    }
                }
            }
        }
    }

    private void saveReport(JFileChooser chooser, String extension, File report) {
        if (this.info == null) {
            JOptionPane.showMessageDialog(this, "Validation hasn't been run.", "Error", 0);
        } else {
            chooser.setSelectedFile(new File(extension.toLowerCase() + "Report.html"));
            int resultChoose = chooser.showSaveDialog(this);
            if (resultChoose == 0) {
                File temp = chooser.getSelectedFile();
                if (!temp.getName().toLowerCase().endsWith("." + extension.toLowerCase())) {
                    temp = new File(temp.getPath() + "." + extension.toLowerCase());
                }
                try {
                    try {
                        Files.copy(report.toPath(), temp.toPath(), new CopyOption[0]);
                        if ("html".equals(extension.toLowerCase())) {
                            File newImage = new File(temp.getParentFile(), this.image.getName());
                            Files.copy(this.image.toPath(), newImage.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (FileAlreadyExistsException e1) {
                        int resultOption = JOptionPane.showConfirmDialog(this, extension.toUpperCase() + " file with the same name already exists. Do you want to overwrite it?", "", 0);
                        if (resultOption == 0) {
                            Files.copy(report.toPath(), temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            if ("html".equals(extension.toLowerCase())) {
                                File newImage = new File(temp.getParentFile(), this.image.getName());
                                Files.copy(this.image.toPath(), newImage.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "Some error in saving the HTML report.", "Error", 0);
                    logger.log(Level.SEVERE, "Exception in saving " + extension.toUpperCase() + " report: ", e);
                }
            }
        }
    }
}

