/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.name;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.name.GenerationalCache;
import org.apache.jackrabbit.name.NameException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathResolver;

public class CachingPathResolver
implements PathResolver {
    private final PathResolver resolver;
    private final GenerationalCache cache;

    public CachingPathResolver(PathResolver resolver, GenerationalCache cache) {
        this.resolver = resolver;
        this.cache = cache;
    }

    public CachingPathResolver(PathResolver resolver) {
        this(resolver, new GenerationalCache());
    }

    public Path getQPath(String path) throws NameException, NamespaceException {
        Path qpath = (Path)this.cache.get(path);
        if (qpath == null) {
            qpath = this.resolver.getQPath(path);
            this.cache.put(path, qpath);
        }
        return qpath;
    }

    public String getJCRPath(Path qpath) throws NamespaceException {
        String path = (String)this.cache.get(qpath);
        if (path == null) {
            path = this.resolver.getJCRPath(qpath);
            this.cache.put(qpath, path);
        }
        return path;
    }
}

