/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.profile.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.verapdf.validation.profile.model.Rule;
import org.verapdf.validation.profile.model.Variable;

public class ValidationProfile {
    private String attrModel;
    private String name;
    private String description;
    private String creator;
    private String created;
    private String hash;
    private Map<String, List<Rule>> rules;
    private Map<String, List<Variable>> variables;

    public ValidationProfile(String attrModel, String name, String description, String creator, String created, String hash, Map<String, List<Rule>> rules, Map<String, List<Variable>> variables) {
        this.attrModel = attrModel;
        this.name = name;
        this.description = description;
        this.creator = creator;
        this.created = created;
        this.hash = hash;
        this.rules = rules;
        this.variables = variables;
    }

    public String getAttrModel() {
        return this.attrModel;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getCreated() {
        return this.created;
    }

    public String getHash() {
        return this.hash;
    }

    public List<Rule> getRoolsForObject(String objName) {
        return this.rules != null ? this.rules.get(objName) : new ArrayList<Rule>();
    }

    public Rule getRuleById(String id) {
        if (id == null) {
            return null;
        }
        if (this.rules != null) {
            for (List<Rule> ruleList : this.rules.values()) {
                if (ruleList == null) continue;
                for (Rule rule : ruleList) {
                    if (rule == null || !id.equals(rule.getAttrID())) continue;
                    return rule;
                }
            }
        }
        return null;
    }

    public List<String> getAllRulesId() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.rules != null) {
            for (List<Rule> ruleList : this.rules.values()) {
                if (ruleList == null) continue;
                for (Rule rule : ruleList) {
                    if (rule == null) continue;
                    result.add(rule.getAttrID());
                }
            }
        }
        return result;
    }

    public List<Variable> getVariablesForObject(String objName) {
        return this.variables != null ? this.variables.get(objName) : new ArrayList<Variable>();
    }

    public List<Variable> getAllVariables() {
        ArrayList<Variable> result = new ArrayList<Variable>();
        if (this.variables != null) {
            for (List<Variable> variablesList : this.variables.values()) {
                if (variablesList == null) continue;
                result.addAll(variablesList);
            }
        }
        return result;
    }
}

