/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Formatter;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.verapdf.features.tools.FeaturesCollection;
import org.verapdf.report.XMLFeaturesReport;
import org.verapdf.report.XMLValidationReport;
import org.verapdf.validation.report.model.ValidationInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XMLReport {
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_MIN = 60000L;
    private static final long MS_IN_SEC = 1000L;

    private XMLReport() {
    }

    private static String getProcessingTimeAsString(long processTime) {
        long processingTime = processTime;
        StringBuilder buffer = new StringBuilder();
        long hours = processingTime / 3600000L;
        long mins = (processingTime %= 3600000L) / 60000L;
        long sec = (processingTime %= 60000L) / 1000L;
        long ms = processingTime %= 1000L;
        buffer.append(new Formatter().format("%02d", hours));
        buffer.append(":");
        buffer.append(new Formatter().format("%02d", mins));
        buffer.append(":");
        buffer.append(new Formatter().format("%02d", sec));
        buffer.append(".");
        buffer.append(new Formatter().format("%03d", ms));
        return buffer.toString();
    }

    public static Element makeXMLTree(ValidationInfo info, FeaturesCollection collection, Document doc, long processingTimeInMS) throws DatatypeConfigurationException {
        Element report = doc.createElement("report");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        XMLGregorianCalendar now = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
        report.setAttribute("creationDateTime", now.toXMLFormat());
        report.setAttribute("processingTime", XMLReport.getProcessingTimeAsString(processingTimeInMS));
        report.appendChild(doc.createElement("documentInfo"));
        report.appendChild(doc.createElement("processingInfo"));
        if (info != null) {
            report.appendChild(XMLValidationReport.makeXMLTree(info, doc));
        }
        if (collection != null) {
            report.appendChild(XMLFeaturesReport.makeXMLTree(collection, doc));
        }
        return report;
    }

    private static Document generateDOMDocument(ValidationInfo info, FeaturesCollection collection, long processingTimeInMS) throws ParserConfigurationException, DatatypeConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        doc.appendChild(XMLReport.makeXMLTree(info, collection, doc, processingTimeInMS));
        return doc;
    }

    private static void transform(Document doc, StreamResult outputTarget) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), outputTarget);
    }

    public static void writeXMLReport(ValidationInfo info, String path, long processingTimeInMS) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, FileNotFoundException, DatatypeConfigurationException {
        XMLReport.writeXMLReport(info, null, path, processingTimeInMS);
    }

    public static void writeXMLReport(ValidationInfo info, FeaturesCollection collection, String path, long processingTimeInMS) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, FileNotFoundException, DatatypeConfigurationException {
        Document doc = XMLReport.generateDOMDocument(info, collection, processingTimeInMS);
        try (FileOutputStream fos = new FileOutputStream(path);){
            XMLReport.transform(doc, new StreamResult(fos));
        }
        catch (IOException excep) {
            // empty catch block
        }
    }

    public static String getXMLReportAsString(ValidationInfo info, long processingTimeInMS) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, FileNotFoundException, DatatypeConfigurationException {
        return XMLReport.getXMLReportAsString(info, null, processingTimeInMS);
    }

    public static String getXMLReportAsString(ValidationInfo info, FeaturesCollection collection, long processingTimeInMS) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, FileNotFoundException, DatatypeConfigurationException {
        Document doc = XMLReport.generateDOMDocument(info, collection, processingTimeInMS);
        StringWriter writer = new StringWriter();
        XMLReport.transform(doc, new StreamResult(writer));
        return writer.getBuffer().toString();
    }
}

