/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class HTMLReport {
    private static final String LOGO_NAME = "veraPDF-logo-200.png";

    private HTMLReport() {
    }

    public static void writeHTMLReport(String htmlReportPath, File xmlReport, File validationProfile) throws TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(HTMLReport.class.getClassLoader().getResourceAsStream("HTMLReportStylesheet.xsl")));
        transformer.setParameter("profilePath", validationProfile.getAbsolutePath());
        transformer.transform(new StreamSource(xmlReport), new StreamResult(new FileOutputStream(htmlReportPath)));
        File dir = new File(htmlReportPath).getParentFile();
        InputStream imageResource = HTMLReport.class.getClassLoader().getResourceAsStream(LOGO_NAME);
        File image = new File(dir, LOGO_NAME);
        try (FileOutputStream outStream = new FileOutputStream(image);){
            int read;
            byte[] bytes = new byte[imageResource.available()];
            while ((read = imageResource.read(bytes)) != -1) {
                ((OutputStream)outStream).write(bytes, 0, read);
            }
        }
    }

    public static String getLogoImageName() {
        return LOGO_NAME;
    }
}

