/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBOutputIntentsFeaturesObject
implements IFeaturesObject {
    private PDOutputIntent outInt;

    public PBOutputIntentsFeaturesObject(PDOutputIntent outInt) {
        this.outInt = outInt;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.OUTPUTINTENT;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.outInt != null) {
            FeatureTreeNode root = FeatureTreeNode.newInstance("outputIntent", null);
            this.addSubtype(collection, root);
            if (this.outInt.getOutputCondition() != null) {
                FeatureTreeNode.newInstance("outputCondition", this.outInt.getOutputCondition(), root);
            }
            if (this.outInt.getOutputConditionIdentifier() != null) {
                FeatureTreeNode.newInstance("outputConditionIdentifier", this.outInt.getOutputConditionIdentifier(), root);
            }
            if (this.outInt.getRegistryName() != null) {
                FeatureTreeNode.newInstance("registryName", this.outInt.getRegistryName(), root);
            }
            if (this.outInt.getInfo() != null) {
                FeatureTreeNode.newInstance("info", this.outInt.getInfo(), root);
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.OUTPUTINTENT, root);
            return root;
        }
        return null;
    }

    private void addSubtype(FeaturesCollection collection, FeatureTreeNode root) throws FeaturesTreeNodeException {
        COSBase base = this.outInt.getCOSObject();
        if (base instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)base;
            COSBase baseType = dict.getDictionaryObject(COSName.S);
            while (baseType instanceof COSObject) {
                baseType = ((COSObject)baseType).getObject();
            }
            if (baseType != null) {
                FeatureTreeNode type = FeatureTreeNode.newInstance("subtype", root);
                if (baseType instanceof COSName) {
                    type.setValue(((COSName)baseType).getName());
                } else {
                    type.addAttribute("errorId", "outinterr1");
                    ErrorsHelper.addErrorIntoCollection(collection, "outinterr1", "In OutputIntent dictionary value for key \"S\" must be of type CosName.");
                }
            }
        }
    }
}

