/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.verapdf.exceptions.featurereport.FeaturesTreeNodeException;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBLowLvlInfoFeaturesObject
implements IFeaturesObject {
    private static Map<String, String> filtersAbbreviations = new HashMap<String, String>();
    private COSDocument document;

    public PBLowLvlInfoFeaturesObject(COSDocument document) {
        this.document = document;
    }

    @Override
    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.LOW_LEVEL_INFO;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeaturesTreeNodeException {
        if (this.document != null) {
            FeatureTreeNode root = FeatureTreeNode.newInstance("lowLevelInfo", null);
            if (this.document.getObjects() != null) {
                FeatureTreeNode.newInstance("indirectObjectsNumber", String.valueOf(this.document.getObjects().size()), root);
            }
            this.addDocumentId(root, collection);
            Set<String> filters = this.getAllFilters();
            if (filters.size() != 0) {
                FeatureTreeNode filtersNode = FeatureTreeNode.newInstance("filters", root);
                for (String filter : filters) {
                    if (filter == null) continue;
                    FeatureTreeNode filterNode = FeatureTreeNode.newInstance("filter", filtersNode);
                    filterNode.addAttribute("name", filter);
                }
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.LOW_LEVEL_INFO, root);
            return root;
        }
        return null;
    }

    private Set<String> getAllFilters() {
        HashSet<String> res = new HashSet<String>();
        for (COSBase base : this.document.getObjects()) {
            while (base instanceof COSObject) {
                base = ((COSObject)base).getObject();
            }
            if (!(base instanceof COSStream)) continue;
            COSStream stream = (COSStream)base;
            COSBase baseFilter = stream.getFilters();
            if (baseFilter != null) {
                PBLowLvlInfoFeaturesObject.addFiltersFromBase(res, baseFilter);
            }
            try {
                PDFStreamParser streamParser = new PDFStreamParser(stream);
                streamParser.parse();
                for (Object token : streamParser.getTokens()) {
                    COSDictionary dict;
                    if (!(token instanceof Operator) || (dict = ((Operator)token).getImageParameters()) == null) continue;
                    COSBase baseOpItem = dict.getDictionaryObject(COSName.F);
                    while (baseOpItem instanceof COSObject) {
                        baseOpItem = ((COSObject)baseOpItem).getObject();
                    }
                    PBLowLvlInfoFeaturesObject.addFiltersFromBase(res, baseOpItem);
                }
            }
            catch (IOException ignore) {
            }
        }
        return res;
    }

    private void addDocumentId(FeatureTreeNode root, FeaturesCollection collection) throws FeaturesTreeNodeException {
        COSArray ids = this.document.getDocumentID();
        if (ids != null) {
            String creationId = PBLowLvlInfoFeaturesObject.getStringFromBase(ids.get(0));
            String modificationId = PBLowLvlInfoFeaturesObject.getStringFromBase(ids.get(1));
            FeatureTreeNode documentId = FeatureTreeNode.newInstance("documentId", root);
            if (creationId != null || modificationId != null) {
                if (creationId != null) {
                    documentId.addAttribute("creationId", creationId);
                }
                if (modificationId != null) {
                    documentId.addAttribute("modificationId", modificationId);
                }
            }
            if (ids.size() != 2 || creationId == null || modificationId == null) {
                documentId.addAttribute("errorId", "llierr1");
                ErrorsHelper.addErrorIntoCollection(collection, "llierr1", "In Trailer dictionary value for key \"ID\" must be an array of two Strings.");
            }
        }
    }

    private static void addFiltersFromBase(Set<String> res, COSBase base) {
        if (base instanceof COSName) {
            String name = ((COSName)base).getName();
            if (filtersAbbreviations.keySet().contains(name)) {
                name = filtersAbbreviations.get(name);
            }
            res.add(name);
        } else if (base instanceof COSArray) {
            for (COSBase baseElement : (COSArray)base) {
                if (!(baseElement instanceof COSName)) continue;
                String name = ((COSName)baseElement).getName();
                if (filtersAbbreviations.keySet().contains(name)) {
                    name = filtersAbbreviations.get(name);
                }
                res.add(name);
            }
        }
    }

    private static String getStringFromBase(COSBase baseParam) {
        COSBase base = baseParam;
        while (base instanceof COSObject) {
            base = ((COSObject)base).getObject();
        }
        if (base instanceof COSString) {
            COSString str = (COSString)base;
            return str.isHex() != false ? str.toHexString() : str.getString();
        }
        return null;
    }

    static {
        filtersAbbreviations.put("AHx", "ASCIIHexDecode");
        filtersAbbreviations.put("A85", "ASCII85Decode");
        filtersAbbreviations.put("LZW", "LZWDecode");
        filtersAbbreviations.put("Fl", "FlateDecode");
        filtersAbbreviations.put("RL", "RunLengthDecode");
        filtersAbbreviations.put("CCF", "CCITTFaxDecode");
        filtersAbbreviations.put("DCT", "DCTDecode");
    }
}

