/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.validation.logic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.verapdf.exceptions.validationlogic.JavaScriptEvaluatingException;
import org.verapdf.exceptions.validationlogic.MultiplyGlobalVariableNameException;
import org.verapdf.exceptions.validationlogic.NullLinkException;
import org.verapdf.exceptions.validationlogic.NullLinkNameException;
import org.verapdf.exceptions.validationlogic.NullLinkedObjectException;
import org.verapdf.exceptions.validationlogic.RullWithNullIDException;
import org.verapdf.exceptions.validationprofileparser.IncorrectImportPathException;
import org.verapdf.exceptions.validationprofileparser.MissedHashTagException;
import org.verapdf.exceptions.validationprofileparser.NullProfileException;
import org.verapdf.exceptions.validationprofileparser.WrongProfileEncodingException;
import org.verapdf.exceptions.validationprofileparser.WrongSignatureException;
import org.verapdf.validation.profile.model.Rule;
import org.verapdf.validation.profile.model.ValidationProfile;
import org.verapdf.validation.profile.model.Variable;
import org.verapdf.validation.profile.parser.ValidationProfileParser;
import org.verapdf.validation.report.model.Check;
import org.verapdf.validation.report.model.CheckError;
import org.verapdf.validation.report.model.CheckLocation;
import org.verapdf.validation.report.model.Details;
import org.verapdf.validation.report.model.Profile;
import org.verapdf.validation.report.model.Result;
import org.verapdf.validation.report.model.ValidationInfo;
import org.xml.sax.SAXException;

public class Validator {
    private Stack<org.verapdf.model.baselayer.Object> objectsStack;
    private Stack<String> objectsContext;
    private Stack<Set<String>> contextSet;
    private Map<String, List<Check>> checkMap;
    private Map<String, Object> variablesMap;
    private Set<String> idSet;
    private String rootType;
    private ValidationProfile profile;

    protected Validator(ValidationProfile profile) {
        this.profile = profile;
    }

    private ValidationInfo validate(org.verapdf.model.baselayer.Object root) throws NullLinkNameException, JavaScriptEvaluatingException, NullLinkException, NullLinkedObjectException, RullWithNullIDException, MultiplyGlobalVariableNameException {
        this.objectsStack = new Stack();
        this.objectsContext = new Stack();
        this.contextSet = new Stack();
        ArrayList<String> warnings = new ArrayList<String>();
        this.idSet = new HashSet<String>();
        this.checkMap = new HashMap<String, List<Check>>();
        this.variablesMap = new HashMap<String, Object>();
        if (this.profile == null) {
            return new ValidationInfo(new Profile("", ""), new Result(new Details(new ArrayList<org.verapdf.validation.report.model.Rule>(), new ArrayList<String>())));
        }
        for (String id : this.profile.getAllRulesId()) {
            this.checkMap.put(id, new ArrayList());
        }
        if (root == null) {
            ArrayList<org.verapdf.validation.report.model.Rule> rules = new ArrayList<org.verapdf.validation.report.model.Rule>();
            for (Map.Entry<String, List<Check>> id : this.checkMap.entrySet()) {
                rules.add(new org.verapdf.validation.report.model.Rule(id.getKey(), id.getValue()));
            }
            return new ValidationInfo(new Profile(this.profile.getName(), this.profile.getHash()), new Result(new Details(rules, warnings)));
        }
        this.initializeAllVariables();
        this.rootType = root.getType();
        this.objectsStack.push(root);
        this.objectsContext.push("root");
        HashSet<String> rootIDContext = new HashSet<String>();
        if (root.getID() != null) {
            rootIDContext.add(root.getID());
            this.idSet.add(root.getID());
        }
        this.contextSet.push(rootIDContext);
        while (!this.objectsStack.isEmpty()) {
            this.checkNext();
        }
        ArrayList<org.verapdf.validation.report.model.Rule> rules = new ArrayList<org.verapdf.validation.report.model.Rule>();
        for (Map.Entry<String, List<Check>> id : this.checkMap.entrySet()) {
            rules.add(new org.verapdf.validation.report.model.Rule(id.getKey(), id.getValue()));
        }
        return new ValidationInfo(new Profile(this.profile.getName(), this.profile.getHash()), new Result(new Details(rules, warnings)));
    }

    private void initializeAllVariables() throws JavaScriptEvaluatingException, MultiplyGlobalVariableNameException {
        if (this.profile.getAllVariables() != null) {
            for (Variable var : this.profile.getAllVariables()) {
                Object res;
                if (var == null) continue;
                if (this.variablesMap.containsKey(var.getAttrName())) {
                    throw new MultiplyGlobalVariableNameException("Founded multiply variable with name: " + var.getAttrName() + "\".");
                }
                Context cx = Context.enter();
                ScriptableObject scope = cx.initStandardObjects();
                try {
                    res = cx.evaluateString((Scriptable)scope, var.getDefaultValue(), null, 0, null);
                }
                catch (Exception e) {
                    throw new JavaScriptEvaluatingException("Problem with evaluating default value of the variable: \"" + var.getAttrName() + "\".", (Throwable)e);
                }
                if (res instanceof NativeJavaObject) {
                    res = ((NativeJavaObject)res).unwrap();
                }
                this.variablesMap.put(var.getAttrName(), res);
                Context.exit();
            }
        }
    }

    private boolean checkNext() throws JavaScriptEvaluatingException, NullLinkException, NullLinkedObjectException, NullLinkNameException, RullWithNullIDException {
        org.verapdf.model.baselayer.Object checkObject = this.objectsStack.pop();
        String checkContext = this.objectsContext.pop();
        Set<String> checkIDContext = this.contextSet.pop();
        boolean res = this.checkAllRules(checkObject, checkContext);
        this.updateVariables(checkObject, checkContext);
        this.addAllLinkedObjects(checkObject, checkContext, checkIDContext);
        return res;
    }

    private void updateVariables(org.verapdf.model.baselayer.Object object, String context) throws JavaScriptEvaluatingException {
        if (this.profile.getVariablesForObject(object.getType()) != null) {
            for (Variable var : this.profile.getVariablesForObject(object.getType())) {
                Object res;
                if (var == null) continue;
                Context cx = Context.enter();
                ScriptableObject scope = cx.initStandardObjects();
                scope.put("obj", (Scriptable)scope, (Object)object);
                for (Map.Entry<String, Object> entry : this.variablesMap.entrySet()) {
                    scope.put(entry.getKey(), (Scriptable)scope, entry.getValue());
                }
                String valScript = this.getScriptPrefix(object) + var.getValue() + this.getScriptSuffix();
                try {
                    res = cx.evaluateString((Scriptable)scope, valScript, null, 0, null);
                }
                catch (Exception e) {
                    throw new JavaScriptEvaluatingException("Problem with evaluating value of the variable: \"" + var.getAttrName() + "\" for object: " + object.getType() + " with context: " + context, (Throwable)e);
                }
                if (res instanceof NativeJavaObject) {
                    res = ((NativeJavaObject)res).unwrap();
                }
                this.variablesMap.put(var.getAttrName(), res);
                Context.exit();
            }
        }
    }

    private void addAllLinkedObjects(org.verapdf.model.baselayer.Object checkObject, String checkContext, Set<String> checkIDContext) throws NullLinkNameException, NullLinkException, NullLinkedObjectException {
        for (int j = checkObject.getLinks().size() - 1; j >= 0; --j) {
            String link = (String)checkObject.getLinks().get(j);
            if (link != null) {
                List objects = checkObject.getLinkedObjects(link);
                if (objects != null) {
                    for (int i = 0; i < objects.size(); ++i) {
                        org.verapdf.model.baselayer.Object obj = (org.verapdf.model.baselayer.Object)objects.get(i);
                        StringBuilder path = new StringBuilder(checkContext);
                        path.append("/");
                        path.append(link);
                        path.append("[");
                        path.append(i);
                        path.append("]");
                        if (obj != null) {
                            if (!this.checkRequired(obj, checkIDContext)) continue;
                            this.objectsStack.push(obj);
                            HashSet<String> newCheckIDContext = new HashSet<String>(checkIDContext);
                            if (obj.getID() != null) {
                                path.append("(");
                                path.append(obj.getID());
                                path.append(")");
                                newCheckIDContext.add(obj.getID());
                                this.idSet.add(obj.getID());
                            }
                            this.objectsContext.push(path.toString());
                            this.contextSet.push(newCheckIDContext);
                            continue;
                        }
                        throw new NullLinkedObjectException("There is a null link in an object. Context of the link: " + path);
                    }
                    continue;
                }
                throw new NullLinkException("There is a null link in an object. Context: " + checkContext);
            }
            throw new NullLinkNameException("There is a null link name in an object. Context: " + checkContext);
        }
    }

    private boolean checkRequired(org.verapdf.model.baselayer.Object obj, Set<String> checkIDContext) {
        if (obj.getID() == null) {
            return true;
        }
        if (obj.isContextDependent() == null || obj.isContextDependent().booleanValue()) {
            return !checkIDContext.contains(obj.getID());
        }
        return !this.idSet.contains(obj.getID());
    }

    private boolean checkAllRules(org.verapdf.model.baselayer.Object checkObject, String checkContext) throws JavaScriptEvaluatingException, RullWithNullIDException {
        boolean res = true;
        if (this.profile.getRoolsForObject(checkObject.getType()) != null) {
            for (Rule rule : this.profile.getRoolsForObject(checkObject.getType())) {
                if (rule == null) continue;
                res &= this.checkObjWithRule(checkObject, checkContext, rule, this.getScript(checkObject, rule));
            }
        }
        for (String checkType : checkObject.getSuperTypes()) {
            if (this.profile.getRoolsForObject(checkType) == null) continue;
            for (Rule rule : this.profile.getRoolsForObject(checkType)) {
                if (rule == null) continue;
                res &= this.checkObjWithRule(checkObject, checkContext, rule, this.getScript(checkObject, rule));
            }
        }
        return res;
    }

    private String getScript(org.verapdf.model.baselayer.Object obj, Rule rule) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getScriptPrefix(obj));
        builder.append("(");
        builder.append(rule.getTest());
        builder.append(")==true");
        builder.append(this.getScriptSuffix());
        return builder.toString();
    }

    private String getScriptPrefix(org.verapdf.model.baselayer.Object obj) {
        StringBuilder builder = new StringBuilder();
        for (String prop : obj.getProperties()) {
            builder.append("var " + prop + " = obj.get" + prop + "();\n");
        }
        for (String linkName : obj.getLinks()) {
            List linkedObject = obj.getLinkedObjects(linkName);
            builder.append("var " + linkName + "_size = " + linkedObject.size() + ";\n");
        }
        builder.append("function test(){return ");
        return builder.toString();
    }

    private String getScriptSuffix() {
        return ";}\ntest();";
    }

    private boolean checkObjWithRule(org.verapdf.model.baselayer.Object obj, String context, Rule rule, String script) throws JavaScriptEvaluatingException, RullWithNullIDException {
        Boolean res;
        Context cx = Context.enter();
        ScriptableObject scope = cx.initStandardObjects();
        scope.put("obj", (Scriptable)scope, (Object)obj);
        for (Map.Entry<String, Object> entry : this.variablesMap.entrySet()) {
            scope.put(entry.getKey(), (Scriptable)scope, entry.getValue());
        }
        try {
            res = (Boolean)cx.evaluateString((Scriptable)scope, script, null, 0, null);
        }
        catch (Exception e) {
            throw new JavaScriptEvaluatingException("Problem with evaluating test: \"" + rule.getTest() + "\" for object with context: " + context, (Throwable)e);
        }
        CheckLocation loc = new CheckLocation(this.rootType, context);
        Check check = res != false ? new Check("passed", loc, null, false) : this.createFailCkeck(obj, loc, rule, cx, scope, context);
        if (rule.getAttrID() == null) {
            throw new RullWithNullIDException("There is a rule with null id in the profile. Profile name: " + this.profile.getName());
        }
        this.checkMap.get(rule.getAttrID()).add(check);
        Context.exit();
        return res;
    }

    private Check createFailCkeck(org.verapdf.model.baselayer.Object obj, CheckLocation loc, Rule rule, Context cx, ScriptableObject scope, String context) throws JavaScriptEvaluatingException {
        String errorMessage;
        ArrayList<String> args = new ArrayList<String>();
        if (rule.getRuleError() != null) {
            errorMessage = rule.getRuleError().getMessage();
            if (rule.getRuleError().getArgument() != null) {
                for (String arg : rule.getRuleError().getArgument()) {
                    Object resArg;
                    if (arg == null) continue;
                    String argScript = this.getScriptPrefix(obj) + arg + this.getScriptSuffix();
                    try {
                        resArg = cx.evaluateString((Scriptable)scope, argScript, null, 0, null);
                    }
                    catch (Exception e) {
                        throw new JavaScriptEvaluatingException("Problem with evaluating argument: " + arg + "for object with context: " + context, (Throwable)e);
                    }
                    String resStringArg = resArg instanceof NativeJavaObject ? ((NativeJavaObject)resArg).unwrap().toString() : resArg.toString();
                    args.add(resStringArg);
                }
            }
        } else {
            errorMessage = null;
        }
        CheckError error = new CheckError(errorMessage, args);
        return new Check("failed", loc, error, rule.isHasError());
    }

    public static ValidationInfo validate(org.verapdf.model.baselayer.Object root, String validationProfilePath, boolean isSignCheckOn) throws IOException, SAXException, ParserConfigurationException, IncorrectImportPathException, NullLinkNameException, JavaScriptEvaluatingException, NullLinkException, NullLinkedObjectException, RullWithNullIDException, MissedHashTagException, XMLStreamException, WrongSignatureException, WrongProfileEncodingException, NullProfileException, MultiplyGlobalVariableNameException {
        return Validator.validate(root, ValidationProfileParser.parseValidationProfile((String)validationProfilePath, (boolean)isSignCheckOn));
    }

    public static ValidationInfo validate(org.verapdf.model.baselayer.Object root, File validationProfile, boolean isSignCheckOn) throws ParserConfigurationException, SAXException, IOException, IncorrectImportPathException, NullLinkNameException, JavaScriptEvaluatingException, NullLinkException, NullLinkedObjectException, RullWithNullIDException, MissedHashTagException, XMLStreamException, WrongSignatureException, WrongProfileEncodingException, NullProfileException, MultiplyGlobalVariableNameException {
        return Validator.validate(root, ValidationProfileParser.parseValidationProfile((File)validationProfile, (boolean)isSignCheckOn));
    }

    public static ValidationInfo validate(org.verapdf.model.baselayer.Object root, ValidationProfile validationProfile) throws NullLinkNameException, JavaScriptEvaluatingException, NullLinkException, NullLinkedObjectException, RullWithNullIDException, MultiplyGlobalVariableNameException {
        Validator validator = new Validator(validationProfile);
        return validator.validate(root);
    }
}

